% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/player.R
\name{bart_player_season}
\alias{bart_player_season}
\title{Get Player Season Stats}
\usage{
bart_player_season(year = current_season(), stat = "all", conf_only = FALSE)
}
\arguments{
\item{year}{Defaults to current season (YYYY).}

\item{stat}{Indicates statistical split (see details).}

\item{conf_only}{Logical. Filters data by conference-only play; defaults to
`FALSE`.}
}
\value{
Returns a tibble with the number of columns dependent on the value
  supplied to the `stat` argument.
}
\description{
Returns detailed, season-long player statistics on a variety of splits.
}
\details{
Data is split on three statistical types, explained below: \describe{
\item{box}{Returns basic box score stats; sorts by ppg.}
\item{shooting}{Returns play-by-play shooting splits; sorts by ppg.}
\item{adv}{Returns advanced metrics and possession-adjusted box score
statistics; sorts by recruiting rank.}}
}
\examples{
\donttest{bart_player_season(year=2019, stat='adv', conf_only=TRUE)}

}
