% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.group_tna_bootstrap}
\alias{summary.group_tna_bootstrap}
\title{Summarize Bootstrap Results for a Grouped Transition Network}
\usage{
\method{summary}{group_tna_bootstrap}(object, ...)
}
\arguments{
\item{object}{A \code{group_tna_bootstrap} object from \code{\link[=bootstrap]{bootstrap()}}.}

\item{...}{Ignored.}
}
\value{
A \code{summary.group_tna_bootstrap} object containing the weight,
p-value and confidence interval of each edge for each cluster.
}
\description{
Summarize Bootstrap Results for a Grouped Transition Network
}
\examples{
model <- group_tna(engagement_mmm)
# Small number of iterations for CRAN
boot <- bootstrap(model, iter = 10)
summary(boot)

}
\seealso{
Cluster-related functions
\code{\link{bootstrap}()},
\code{\link{centralities}()},
\code{\link{cliques}()},
\code{\link{communities}()},
\code{\link{deprune}()},
\code{\link{estimate_cs}()},
\code{\link{group_model}()},
\code{\link{hist.group_tna}()},
\code{\link{mmm_stats}()},
\code{\link{plot.group_tna}()},
\code{\link{plot.group_tna_centralities}()},
\code{\link{plot.group_tna_cliques}()},
\code{\link{plot.group_tna_communities}()},
\code{\link{plot.group_tna_stability}()},
\code{\link{plot_compare.group_tna}()},
\code{\link{plot_mosaic.group_tna}()},
\code{\link{plot_mosaic.tna_data}()},
\code{\link{print.group_tna}()},
\code{\link{print.group_tna_bootstrap}()},
\code{\link{print.group_tna_centralities}()},
\code{\link{print.group_tna_cliques}()},
\code{\link{print.group_tna_communities}()},
\code{\link{print.group_tna_stability}()},
\code{\link{print.summary.group_tna}()},
\code{\link{print.summary.group_tna_bootstrap}()},
\code{\link{prune}()},
\code{\link{pruning_details}()},
\code{\link{rename_groups}()},
\code{\link{reprune}()},
\code{\link{summary.group_tna}()}
}
\concept{clusters}
