% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.tna_stability}
\alias{plot.tna_stability}
\title{Plot Centrality Stability Results}
\usage{
\method{plot}{tna_stability}(x, level = 0.05, ...)
}
\arguments{
\item{x}{A \code{tna_stability} object produced by \code{estimate_cs}.}

\item{level}{A \code{numeric} value representing the significance level for
the confidence intervals. Defaults to \code{0.05}.}

\item{...}{Ignored.}
}
\value{
A \code{ggplot} object displaying the stability analysis plot.
}
\description{
This function visualizes the centrality stability results produced by the
\code{estimate_centrality_stability} function. It shows how different centrality
measures' correlations change as varying proportions of cases are dropped,
along with their confidence intervals (CIs).
}
\details{
The function aggregates the results for each centrality measure across
multiple proportions of dropped cases (e.g., 0.1, 0.2, ..., 0.9) and
calculates the mean and the desired quantiles for each proportion.
The confidence intervals (CIs) are computed based on the quantiles
and displayed in the plot.

If no valid data is available for a centrality measure
(e.g., missing or NA values), the function skips that measure with a warning.

The plot includes:
\itemize{
\item The mean correlation for each centrality measure as a function of the
proportion of dropped cases.
\item Shaded confidence intervals representing CIs for each centrality measure.
\item A horizontal dashed line at the threshold value used for calculating
the CS-coefficient.
\item A subtitle listing the CS-coefficients for each centrality measure.
}
}
\examples{
model <- tna(group_regulation)
cs <- estimate_cs(model, iter = 10)
plot(cs)

}
