% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statisticaltests.R
\name{tmodDecideTests}
\alias{tmodDecideTests}
\title{Count the Up- or Down-regulated genes per module}
\usage{
tmodDecideTests(g, lfc = NULL, pval = NULL, lfc.thr = 0.5,
  pval.thr = 0.05, labels = NULL, filter.unknown = FALSE, mset = "all")
}
\arguments{
\item{g}{a character vector with gene symbols}

\item{lfc}{a numeric vector or a matrix with log fold changes}

\item{pval}{a numeric vector or a matrix with p-values. Must have the same dimensions as lfc}

\item{lfc.thr}{log fold change threshold}

\item{pval.thr}{p-value threshold}

\item{labels}{Names of the comparisons. Either NULL or a character
vector of length equal to the number of columns in lfc and pval.}

\item{filter.unknown}{If TRUE, modules with no annotation will be omitted}

\item{mset}{Which module set to use. Either a character vector ("LI", "DC" or "all", default: LI) or a list (see "Custom module definitions" below)}
}
\value{
A list with as many elements as there were comparisons (columns in lfc and pval). Each element of the list is a data 
frame with the columns "Down", "Zero" and "Up" giving the number of the
down-, not- and up-regulated genes respectively. Rows of the data frame
correspond to module IDs.
}
\description{
For each module in a set, calculate the number of genes which are in
that module and which are significantly up- or down-regulated.
}
\details{
This function can be used to decide whether a module, as a whole, is up- or
down regulated. For each module, it calculates the number of genes which
are up-, down- or not regulated. 
A gene is considered to be up- regulated
if the associated p-value is smaller than pval.thr and the associated log
fold change is greater than lfc.thr.
A gene is considered to be down- regulated
if the associated p-value is smaller than pval.thr and the associated log
fold change is smaller than lfc.thr.

Note that unlike decideTests from limma, tmodDecideTests does not correct
the p-values for multiple testing -- therefore, the p-values should already
be corrected.
}
\seealso{
tmodSummary, tmodPanelPlot, tmodDecideTestsLimma
}

