% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/tmodPanelPlot.R
\name{tmodPanelPlot}
\alias{tmodPanelPlot}
\title{Plot a summary of multiple tmod analyses}
\usage{
tmodPanelPlot(x, pie = NULL, clust = "qval", filter.empty.cols = FALSE,
  filter.empty.rows = TRUE, filter.unknown = TRUE, filter.by.id = NULL,
  col.labels = NULL, row.labels = NULL, pval.thr = 10^-2,
  plot.func = NULL, grid = "at", pie.colors = c("#0000FF", "#cccccc",
  "#FF0000"), plot.cex = 1, text.cex = 1, pie.style = "pie",
  col.labels.style = "top", legend.style = "auto", ...)
}
\arguments{
\item{x}{list, in which each element has been generated with a tmod test function}

\item{pie}{a data frame or a three-dimensional array with information for drawing a pie chart}

\item{clust}{whether, in the resulting data frame, the modules should be
ordered by clustering them with either q-values ("qval") or the effect size
("effect"). If NULL, the modules are sorted alphabetically by their ID.}

\item{filter.empty.cols}{If TRUE, all elements (columns) with no significant enrichment in any row will be removed}

\item{filter.empty.rows}{If TRUE, all modules (rows) with no significant enrichment in any column will be removed}

\item{filter.unknown}{If TRUE, modules with no annotation will be omitted}

\item{filter.by.id}{if provided, show only modules with IDs in this character vector}

\item{col.labels}{Labels for the columns. If NULL, names of the elements
of the list x will be used.}

\item{row.labels}{Labels for the modules. This must be a named vector, with module IDs as vector names. If NULL, module titles from
the analyses results will be used.}

\item{pval.thr}{Results with p-value above pval.thr will not be shown}

\item{plot.func}{Optionally, a function to be used to draw the dots. See "pvalEffectPlot"}

\item{grid}{Style of a light-grey grid to be plotted; can be "none", "at" and "between"}

\item{pie.colors}{character vector of length equal to the cardinality of the third dimension of the pie argument.}

\item{plot.cex}{a numerical value giving the amount by which the plot
symbols will be maginfied}

\item{text.cex}{a numerical value giving the amount by which the plot
text will be magnified, or a vector containing three cex values for row labels, column labels and legend, respectively}

\item{pie.style}{Can be either "pie" or "rug"}

\item{col.labels.style}{Style of column names: "top" (default), "bottom", "both", "none"}

\item{legend.style}{Style of the legend: "auto" -- automatic; "broad":
pval legend side by side with effect size legend; "tall": effect size
legend above pval legend}

\item{...}{Any further arguments will be passed to the pvalEffectPlot function}
}
\value{
a data frame with a line for each module encountered anywhere in
the list x, two columns describing the module (ID and module title), and
two columns(effect size and q value) for each element of list x.
}
\description{
Plot a summary of multiple tmod analyses
}
\details{
This function is useful if you run an analysis for several conditions or
time points and would like to summarize the information on a plot.
You can use lapply() to generate a list with tmod results and use
tmodPanelPlot to visualize it.

tmodPanelPlot shows a heatmap-like plot. Each row corresponds to one
module, and columns correspond to the time points or conditions for which
the tmod analyses were run. Each significantly enriched module is shown as
a red dot. Size of the dot corresponds to the effect size (for example, AUC
in the CERNO test), and intensity of the color corresponds to the q-value.

By default, tmodPanelPlot visualizes each the results of a single
statistical test by a red dot. However, it is often interesting to know how
many of the genes in a module are significantly up- or down regulated.
tmodPanelPlot can draw a pie chart based on the optional argument "pie".
The argument must be a list of length equal to the length of x.
Objects returned by the function tmodDecideTests can be directly used
here. The rownames of either the data frame or the array must be the
module IDs.
}
\examples{
data(Egambia)
E <- Egambia[,-c(1:3)]
pca <- prcomp(t(E), scale.=TRUE)

# Calculate enrichment for first 5 PCs
gs   <- Egambia$GENE_SYMBOL
gn.f <- function(r) {
    o <- order(abs(r), decreasing=TRUE)
    tmodCERNOtest(gs[o],
                qval=0.01)
}
x <- apply(pca$rotation[,3:4], 2, gn.f)
tmodPanelPlot(x, text.cex=0.7)
}
\seealso{
tmodDecideTests, tmodSummary, pvalEffectPlot
}

