% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/SummariesModelClass.R
\docType{class}
\name{CategorSummaryModel}
\alias{CategorSummaryModel}
\title{R6 class for fitting and predicting joint probability for a univariate categorical summary measure sA[j]}
\format{An \code{\link{R6Class}} generator object}
\usage{
CategorSummaryModel
}
\description{
This R6 class defines and fits a conditional probability model \code{P(sA[j]|sW,...)} for a univariate
 categorical summary measure \code{sA[j]}. This class inherits from \code{\link{SummariesModel}} class.
 Defines the fitting algorithm for a regression model \code{sA[j] ~ sW + ...}.
 Reconstructs the likelihood \code{P(sA[j]=sa[j]|sW,...)} afterwards.
 Categorical \code{sA[j]} is first redefined into \code{length(levels)} bin indicator variables, where
 \code{levels} is a numeric vector of all unique categories in \code{sA[j]}.
 The fitting algorithm estimates the binary regressions for hazard for each bin indicator, \code{Bin_sA[j][i] ~ sW},
 i.e., the probability that categorical \code{sA[j]} falls into bin \code{i}, \code{Bin_sA[j]_i},
 given that \code{sA[j]} does not fall in any prior bins \code{Bin_sA[j]_1, ..., Bin_sA[j]_{i-1}}.
 The dataset of bin indicators (\code{BinsA[j]_1,...,BinsA[j]_M}) is created
 inside the passed \code{data} or \code{newdata} object when defining \code{length(levels)} bins for \code{sA[j]}.
}
\details{
\itemize{
\item{\code{reg}} - .
\item{\code{outvar}} - .
\item{\code{levels}} - .
\item{\code{nbins}} - .
}
}
\section{Methods}{

\describe{
  \item{\code{new(reg, DatNet.sWsA.g0, ...)}}{...}
  \item{\code{fit(data)}}{...}
  \item{\code{predict(newdata)}}{...}
  \item{\code{predictAeqa(newdata)}}{...}
}
}

\section{Active Bindings}{

\describe{
  \item{\code{cats}}{...}
}
}
\keyword{R6}
\keyword{class}

