% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_view.R
\name{tm_view}
\alias{tm_view}
\title{Options for the interactive tmap viewer}
\usage{
tm_view(
  alpha,
  colorNA,
  projection,
  symbol.size.fixed,
  dot.size.fixed,
  text.size.variable,
  bbox,
  set.bounds,
  set.view,
  set.zoom.limits,
  view.legend.position,
  control.position,
  legend.position,
  leaflet.options
)
}
\arguments{
\item{alpha}{transparency (opacity) parameter applied to whole map. By default, it is set to \code{0.7} if basemaps are used, and \code{1} otherwise.}

\item{colorNA}{default color for missing values in interactive mode. If the color of missing values is not defined in the layer functions (e.g. \code{\link{tm_fill}}), then the default color is taken from the \code{na} value of the \code{aes.color} argument in \code{\link{tm_layout}}. This \code{colorNA} argument (if not \code{NA} itself) overrides that default value. For interactive maps, it can be useful to set \code{colorNA} to \code{NULL}, which means transparent.}

\item{projection}{projection. Either a EPSG number, or a \code{leaflet_crs} object created with \code{\link[leaflet:leafletCRS]{leafletCRS}}. By default, the Web Mercator (3857) is used, since the vast majority of basemaps are rendered accordingly. Other standards are EPSG numbers 4326 (WGS84) and 3395 (Mercator). If set to 0, the projection of the master shape is used (see \code{\link{tm_shape}}) provided that a EPSG number can be extracted.}

\item{symbol.size.fixed}{should symbol sizes be fixed while zooming?}

\item{dot.size.fixed}{should dot sizes be fixed while zooming?}

\item{text.size.variable}{should text size variables be allowed in view mode? By default \code{FALSE}, since in many applications, the main reason to vary text size is to prevent occlusion in plot mode, which is often not a problem in view mode due to the ability to zoom in.}

\item{bbox}{bounding box. One of the following:
\itemize{
\item A bounding box (an \code{\link[sf:sf]{sf}} bbox object, see \code{\link[sf:st_bbox]{st_bbox}}, or object that can be read by \code{\link[tmaptools:bb]{bb}}. 
\item Open Street Map search query. The bounding is automatically generated by querying \code{q} from Open Street Map Nominatim. See \url{https://wiki.openstreetmap.org/wiki/Nominatim}.}
If set, it overrides \code{set.view} and all bbox arguments of \code{\link{tm_shape}}.}

\item{set.bounds}{logical that determines whether maximum bounds are set, or a numeric vector of four values that specify the lng1, lat1, lng2, and lat2 coordinates (see \code{\link[leaflet:setMaxBounds]{setMaxBounds}}).}

\item{set.view}{numeric vector that determines the view. Either a vector of three: lng, lat, and zoom, or a single value: zoom. See \code{\link[leaflet:setView]{setView}}. Only applicable if \code{bbox} is not specified}

\item{set.zoom.limits}{numeric vector of two that set the minimum and maximum zoom levels (see \code{\link[leaflet:tileOptions]{tileOptions}}).}

\item{view.legend.position}{Character vector of two values, specifying the position of the legend. Use "left" or "right" for the first value and "top" or "bottom" for the second value. It overrides the value of \code{legend.position} of \code{\link{tm_layout}}, unless set to \code{NA}.}

\item{control.position}{Character vector of two values, specifying the position of the layer control UI. Use "left" or "right" for the first value and "top" or "bottom" for the second value.}

\item{legend.position}{not used anymore, renamed to view.legend.position}

\item{leaflet.options}{other options passed on via \code{\link[leaflet:leaflet]{leafletOptions}} to leaflet.js map creation (see \href{https://leafletjs.com/}{leaflet}, follow Docs, Map, Creation). Named list, where the names correspond to the variable names. Tip: use \code{zoomSnap} and \code{zoomDelta} for fractional zooming.}
}
\description{
Set the options for the interactive tmap viewer. Some of these options can also be set with \code{\link{tm_layout}}, since they are style dependent (e.g., the choice of basemaps). The function \code{tm_view} overrides these options when specified.
}
\examples{
# world choropleth/bubble map of the world
data(World, metro)
metro$growth <- (metro$pop2020 - metro$pop2010) / (metro$pop2010 * 10) * 100

map1 <- tm_shape(metro) +
	tm_bubbles("pop2010", col = "growth", 
		border.col = "black", border.alpha = .5, 
		style="fixed", breaks=c(-Inf, seq(0, 6, by=2), Inf),
		palette="-RdYlBu", contrast=1, 
		title.size="Metro population", 
		title.col="Growth rate (\%)", id="name", 
		    popup.vars=c("pop2010", "pop2020", "growth")) + 
	tm_legend(outside=TRUE)

current.mode <- tmap_mode("plot")

# plot map
map1

# view map with default view options
tmap_mode("view")
map1

# view map with changed view options
map1 + tm_view(set.view = c(7, 51, 4)) # longitude 7, latitude 51, zoom 4

# interactive world map in original CRS
tm_shape(World) +tm_polygons("HPI") + tm_view(projection = 0) + tm_basemap(NULL)

# restore current mode
tmap_mode(current.mode)
}
\references{
Tennekes, M., 2018, {tmap}: Thematic Maps in {R}, Journal of Statistical Software, 84(6), 1-39, \href{https://doi.org/10.18637/jss.v084.i06}{DOI}
}
\seealso{
\href{../doc/tmap-getstarted.html}{\code{vignette("tmap-getstarted")}}
}
