% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tip.R
\name{tip_with_binary}
\alias{tip_with_binary}
\alias{tip_b}
\title{Tip a result with a binary confounder.}
\usage{
tip_with_binary(p1 = NULL, p0 = NULL, gamma = NULL, lb = NULL,
  ub = NULL)

tip_b(p1 = NULL, p0 = NULL, gamma = NULL, lb = NULL, ub = NULL)
}
\arguments{
\item{p1}{estimated prevalence of the unmeasured confounder in the exposed population}

\item{p0}{estimated prevalence of the unmeasured confounder in the unexposed population}

\item{gamma}{estimated size of an unmeasured confounder}

\item{lb}{lower bound of your observed effect}

\item{ub}{upper bound of your observed effect}
}
\description{
Choose two of the following three to specify, and the third will be estimated:
\itemize{
\item \code{p1}
\item \code{p0}
\item \code{gamma}
}

Alternatively, specify all three and the function will return the number of unmeasured
confounders specified needed to tip the analysis.
}
\details{
\code{\link[=tip_b]{tip_b()}} is an alias for \code{\link[=tip_with_binary]{tip_with_binary()}}.
}
\examples{
#to output the size of an unmeasured confounder needed to tip analysis
tip_with_binary(p1 = .5, p0 = 0, lb = 1.2, ub = 1.5)


}
