% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeTable.R
\name{prWriteTable}
\alias{prWriteTable}
\alias{prWriteCsv}
\alias{prWriteCsv2}
\title{Write data in an output text file}
\usage{
prWriteTable(name, ..., replace = FALSE)

prWriteCsv(name, ..., replace = FALSE)

prWriteCsv2(name, ..., replace = FALSE)
}
\arguments{
\item{name}{Name of the object to write. Quotes are optional. This argument can also 
specify the subdirectory of folder "output" where to write the file.}

\item{...}{arguments to \code{write.table}}

\item{replace}{If the file already exists, should it be overwritten ?}
}
\description{
These functions are wrappers to \code{write.table}, \code{write.csv} and 
\code{write.csv2}. They write a matrix or a data.table in a ".txt" or ".csv"
file in the output folder. The file created has the same name as the object.
}
\examples{
projectPath <- file.path(tempdir(), "test")
prInit(projectPath)

mydata <- data.frame(x = 1:10, y = rnorm(10))

prWriteTable(mydata)
list.files(projectPath, recursive = TRUE, include.dirs = TRUE)

# Write in a subdirectory of "output"
prWriteTable("mydir/mydata")
list.files(projectPath, recursive = TRUE, include.dirs = TRUE)

}
