% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setops_match.R
\name{set-ops}
\alias{set-ops}
\alias{unique.tinterval}
\alias{!.tinterval}
\alias{intersect_t}
\alias{union_t}
\alias{setdiff_t}
\title{Set Operations on Time Intervals and Time Indices}
\usage{
\method{unique}{tinterval}(x, ...)

\method{!}{tinterval}(x)

intersect_t(x, y)

union_t(x, y)

setdiff_t(x, y)
}
\arguments{
\item{x}{an object of \code{tinterval} class for \code{unique} method
and \code{!} operator, \code{tinterval} or \code{tind}
for \code{intersect_t}, \code{union_t}, or \code{setdiff_t}.}

\item{...}{(ignored) further arguments passed to or from other methods.}

\item{y}{an object of \code{tinterval} or \code{tind} class.}
}
\value{
An object of \code{tinterval} or \code{tind} class representing result of the set
operation.
}
\description{
Time intervals can be thought of as subsets of time line (set of integers or
real line, depending on index type). The following functions perform
operations on these sets.

\code{unique} method for objects of \code{tinterval} class returns unique
representation as ordered sum of disjoint, non-adjacent intervals.

\code{!} (negation) operator for objects of \code{tinterval} class returns
set-theoretical complement of the argument.

\code{intersect_t}, \code{union_t}, \code{setdiff_t} return intersection,
union and (asymmetric) set difference. These three functions accept
both time intervals and time indices.

Behaviour of \code{!}, \code{intersect_t}, \code{union_t}, and \code{setdiff_t}
is consistent with behaviour of \code{\link{\%in_t\%}} operator.
Consistency is also assured under type conversions.

For time indices, \code{intersect_t}, \code{union_t}, \code{setdiff_t}
behave just like \code{intersect}, \code{union}, \code{setdiff} from \pkg{base}
(see \link[base]{sets}) but preserve class attribute.
}
\details{
For discrete time indices (represented as integers, i.e. years, quarters,
months, weeks, dates, arbitrary integer indices) time intervals represent
the following sets (ignoring empty, i.e. with \eqn{a_i > b_i}):
\deqn{\bigcup_{i = 1}^n A_i = \bigcup_{i = 1}^n \{x: a_i \le x \le b_i\} = \bigcup_{i = 1}^n \{a_i, a_i + 1, \dots, b_i - 1, b_i\}.}
\code{unique} returns the unique (canonical) representation of the set above:
\deqn{\bigcup_{i = 1}^{n'} A'_i = \bigcup_{i = 1}^{n'} \{a'_i, a'_i + 1, \dots, b'_i - 1, b'_i\}}
with \eqn{a'_i \le b'_i < a'_{i + 1} - 1}, i.e. as a sum of ordered, non-empty,
non-adjacent intervals.

For continuous time indices (representing point in time, i.e. date-time, time of day,
arbitrary numeric indices) time intervals represent the following sets
(ignoring empty, i.e. with \eqn{a_i \ge b_i}):
\deqn{\bigcup_{i = 1}^n A_i = \bigcup_{i = 1}^n [a_i, b_i).}
\code{unique} returns unique representation of the set above:
\deqn{\bigcup_{i = 1}^{n'} A'_i = \bigcup_{i = 1}^{n'} [a'_i, b'_i)}
with \eqn{a'_i < b'_i < a'_{i + 1}}, i.e. as a sum of ordered, non-empty,
non-adjacent intervals.

Complement of a single interval for integer indices
\deqn{\{x: a \le x \le b\} = \{a, a + 1, \dots, b - 1, b\}}
is:
\deqn{\{x: x < a\} \cup \{x: x > b\} = \{x: x \le a - 1\} \cup \{x: x \ge b + 1\} = \{\dots, a - 2, a - 1\} \cup \{b + 1, b + 2, \dots\}.}
Complement of a single interval for continuous indices
\deqn{[a, b)}
is:
\deqn{(-\infty, a) \cup [b, \infty).}
Complement of a sum of intervals is the intersection of complements.

Set operations always return results in the canonical representation.
}
\examples{
(x <- tinterval("2025-03-15", "2025-03-20") + c(0, 4, 14))
# unique representation (non-overlapping intervals)
unique(x)
# complement
!x
# binary set operations
(y <- tinterval("2025-03-01", "2025-03-31"))
intersect_t(x, y)
union_t(x, y)
setdiff_t(x, y)
setdiff_t(y, x)
# different types of indices
(y <- tinterval("2025-W10", "2025-W11"))
intersect_t(x, y)
union_t(x, y)
setdiff_t(x, y)
setdiff_t(y, x)
# check
(y <- as.tinterval(y, type = "d"))
intersect_t(x, y)
union_t(x, y)
setdiff_t(x, y)
setdiff_t(y, x)

}
\seealso{
\code{\link{tinterval}} for an overview of time interval class,
\code{\link{match_t}} for matching time indices
}
