% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lubridate-date_parsers.R
\name{parse_date2}
\alias{parse_date2}
\alias{parse_datetime2}
\title{Fast, flexible date and datetime parsing}
\usage{
parse_date2(x, ..., silent = FALSE)

parse_datetime2(x, tz = "UTC", tz_shift = FALSE, ..., silent = FALSE)
}
\arguments{
\item{x}{A character vector}

\item{...}{Additional parameters passed to \code{\link[=anytime]{anytime()}} and \code{\link[=anydate]{anydate()}}}

\item{silent}{If \code{TRUE}, warns the user of parsing failures.}

\item{tz}{Datetime only. A timezone (see \code{OlsenNames()}).}

\item{tz_shift}{Datetime only. If FALSE, forces the datetime into the time zone.
If TRUE, offsets the datetime from UTC to the new time zone.}
}
\value{
Returns a \code{date} or \code{datatime} vector from the transformation applied to character timestamp vector.
}
\description{
Significantly faster time series parsing than \code{readr::parse_date}, \code{readr::parse_datetime},
\code{lubridate::as_date()}, and \code{lubridate::as_datetime()}. Uses \code{anytime} package, which relies on
\code{Boost.Date_Time} C++ library for date/datetime parsing.
}
\details{
\strong{Parsing Formats}
\itemize{
\item Date Formats: Must follow a Year, Month, Day sequence.
(e.g. \code{parse_date2("2011 June")} is OK, \code{parse_date2("June 2011")} is NOT OK).
\item Date Time Formats: Must follow a YMD HMS sequence.
}

Refer to \code{lubridate::mdy()} for Month, Day, Year and additional formats.

\strong{Time zones (Datetime)}

Time zones are handled in a similar way to \code{lubridate::as_datetime()} in that time zones
are forced rather than shifted. This is a key difference between \code{anytime::anytime()}, which
shifts datetimes to the specified timezone by default.
}
\examples{

# Fast date parsing
parse_date2("2011")
parse_date2("2011 June 3rd")

# Fast datetime parsing
parse_datetime2("2011")
parse_datetime2("2011 Jan 1 12:35:21")

# Time Zones (datetime only)
parse_datetime2("2011 Jan 1 12:35:21", tz = "Europe/London")

}
\references{
\itemize{
\item This function wraps the \code{anytime::anytime()} and \code{anytime::anydate} functions developed by Dirk Eddelbuettel.
}
}
