% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr-mutate_by_time.R
\name{mutate_by_time}
\alias{mutate_by_time}
\title{Mutate (for Time Series Data)}
\usage{
mutate_by_time(
  .data,
  .date_var,
  .by = "day",
  ...,
  .type = c("floor", "ceiling", "round")
)
}
\arguments{
\item{.data}{A \code{tbl} object or \code{data.frame}}

\item{.date_var}{A column containing date or date-time values to summarize.
If missing, attempts to auto-detect date column.}

\item{.by}{A time unit to summarise by.
Time units are collapsed using \code{lubridate::floor_date()} or \code{lubridate::ceiling_date()}.

The value can be:
\itemize{
\item \code{second}
\item \code{minute}
\item \code{hour}
\item \code{day}
\item \code{week}
\item \code{month}
\item \code{bimonth}
\item \code{quarter}
\item \code{season}
\item \code{halfyear}
\item \code{year}
}

Arbitrary unique English abbreviations as in the \code{lubridate::period()} constructor are allowed.}

\item{...}{Name-value pairs.
The name gives the name of the column in the output.

The value can be:
\itemize{
\item A vector of length 1, which will be recycled to the correct length.
\item A vector the same length as the current group (or the whole data frame
if ungrouped).
\item \code{NULL}, to remove the column.
\item A data frame or tibble, to create multiple columns in the output.
}}

\item{.type}{One of "floor", "ceiling", or "round. Defaults to "floor". See \code{lubridate::round_date}.}
}
\value{
A \code{tibble} or \code{data.frame}
}
\description{
\code{mutate_by_time()} is a time-based variant of the popular \code{dplyr::mutate()} function
that uses \code{.date_var} to specify a date or date-time column and \code{.by} to group the
calculation by groups like "5 seconds", "week", or "3 months".
}
\examples{
# Libraries
library(timetk)
library(dplyr)
library(tidyr)

# First value in each month
m4_daily_first_by_month_tbl <- m4_daily \%>\%
    group_by(id) \%>\%
    mutate_by_time(
        .date_var = date,
        .by       = "month", # Setup for monthly aggregation
        # mutate recycles a single value
        first_value_by_month  = first(value)
    )
m4_daily_first_by_month_tbl

# Visualize Time Series vs 1st Value Each Month
m4_daily_first_by_month_tbl \%>\%
    pivot_longer(value:first_value_by_month) \%>\%
    plot_time_series(date, value, name,
                     .facet_scale = "free", .facet_ncol = 2,
                     .smooth = FALSE, .interactive = FALSE)

}
\seealso{
Time-Based dplyr functions:
\itemize{
\item \code{\link[=summarise_by_time]{summarise_by_time()}} - Easily summarise using a date column.
\item \code{\link[=mutate_by_time]{mutate_by_time()}} - Simplifies applying mutations by time windows.
\item \code{\link[=pad_by_time]{pad_by_time()}} - Insert time series rows with regularly spaced timestamps
\item \code{\link[=filter_by_time]{filter_by_time()}} - Quickly filter using date ranges.
\item \code{\link[=filter_period]{filter_period()}} - Apply filtering expressions inside periods (windows)
\item \code{\link[=slice_period]{slice_period()}} - Apply slice inside periods (windows)
\item \code{\link[=condense_period]{condense_period()}} - Convert to a different periodicity
\item \code{\link[=between_time]{between_time()}} - Range detection for date or date-time sequences.
\item \code{\link[=slidify]{slidify()}} - Turn any function into a sliding (rolling) function
}
}
