#' timetk: a toolkit for time series
#'
#' The `timetk` package combines a collection of coercion tools for
#' time series analysis.
#'
#'
#'
#' @details
#' The `timetk` package has several benefits:
#'
#' 1. Index extraction: get the time series index from any time series object.
#' 2. Understand time series: create a signature and summary from a time series index.
#' 3. Build future time series: create a future time series from an index.
#' 4. Coerce between time-based tibbles (tbl) and the major time series data types xts, zoo, zooreg, and ts: Simplifies coercion and maximizes time-based data retention during coercion to regularized time series (e.g. ts).
#'
#' To learn more about `timetk`, start with the vignettes:
#' `browseVignettes(package = "timetk")`
#'
#' @docType package
#' @name timetk
#'
#' @importFrom dplyr %>%
#' @importFrom xts xts
#' @import recipes
#' @importFrom generics tidy

NULL
