% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make-tk_make_timeseries_future.R
\name{tk_make_future_timeseries}
\alias{tk_make_future_timeseries}
\title{Make future time series from existing}
\usage{
tk_make_future_timeseries(
  idx,
  n_future,
  inspect_weekdays = FALSE,
  inspect_months = FALSE,
  skip_values = NULL,
  insert_values = NULL,
  include_endpoints = TRUE
)
}
\arguments{
\item{idx}{A vector of dates}

\item{n_future}{Number of future observations. Can be numeric number or a phrase
like "1 year".}

\item{inspect_weekdays}{Uses a logistic regression algorithm to inspect
whether certain weekdays (e.g. weekends) should be excluded from the future dates.
Default is \code{FALSE}.}

\item{inspect_months}{Uses a logistic regression algorithm to inspect
whether certain days of months (e.g. last two weeks of year or seasonal days)
should be excluded from the future dates.
Default is \code{FALSE}.}

\item{skip_values}{A vector of same class as \code{idx} of timeseries
values to skip.}

\item{insert_values}{A vector of same class as \code{idx} of timeseries
values to insert.}

\item{include_endpoints}{Logical. Whether or not to keep the last value when \code{length_out} is
a time-based phrase. Default is \code{TRUE} (keep last value).}
}
\value{
A vector containing future index of the same class as the incoming index \code{idx}
}
\description{
Make future time series from existing
}
\details{
\strong{Future Sequences}

\code{tk_make_future_timeseries} returns a time series based
on the input index frequency and attributes.

\strong{Specifying N Future}

The argument \code{n_future} determines how many future index observations to compute. It can be specified
as:
\itemize{
\item A numeric value - the number of future observations
\item A time-based phrase - The span into the future to include (e.g. "6 months" or "30 minutes")
}

\strong{Weekday and Month Inspection}

The \code{inspect_weekdays} and \code{inspect_months} arguments apply to "daily" (scale = "day") data
(refer to \code{tk_get_timeseries_summary()} to get the index scale).
\itemize{
\item The \code{inspect_weekdays} argument is useful in determining missing days of the week
that occur on a weekly frequency such as every week, every other week, and so on.
It's recommended to have at least 60 days to use this option.
\item The \code{inspect_months} argument is useful in determining missing days of the month, quarter
or year; however, the algorithm can inadvertently select incorrect dates if the pattern
is erratic.
}

\strong{Skipping / Inserting Values}

The \code{skip_values} and \code{insert_values} arguments can be used to remove and add
values into the series of future times. The values must be the same format as the \code{idx} class.
\itemize{
\item The \code{skip_values} argument useful for passing holidays or special index values that should
be excluded from the future time series.
\item The \code{insert_values} argument is useful for adding values back that the algorithm may have
excluded.
}

\strong{Removing Endpoints}

When \code{n_future} is a character phrase, how many observations into the future can differ
based on the user's interpretation to the time-span. For example, should "1 year" mean
1 year from the last value in an index or 1 year from the next value.

To account for this, the user has the option \code{include_endpoints}, which simply subtracts the
last value in the future time series.
}
\examples{
library(dplyr)
library(tidyquant)
library(timetk)

# Basic example - By 3 seconds
idx <- tk_make_timeseries("2016-01-01 00:00:00", by = "3 sec", length_out = 3)
idx

# Make next three timestamps in series
idx \%>\% tk_make_future_timeseries(n_future = 3)

# Make next 6 seconds of timestamps from the next timestamp
idx \%>\% tk_make_future_timeseries(n_future = "6 sec")

# Make next 6 seconds of timestamps from the previous timestamp
idx \%>\% tk_make_future_timeseries(n_future = "6 sec", include_endpoints = FALSE)


# Basic Example - By 1 Month
idx <- tk_make_timeseries("2016-01-01", by = "1 month",
                          length_out = "12 months",
                          include_endpoints = FALSE)
idx

# Make 12 months of timestamps from the next timestamp
idx \%>\% tk_make_future_timeseries(n_future = "12 months")

# Make 12 months of timestamps from the previous timestamp
idx \%>\% tk_make_future_timeseries(n_future = "12 months", include_endpoints = FALSE)


# --- APPLICATION ---
# - Combine holiday sequences with future sequences

# Create index of days that FB stock will be traded in 2017 based on 2016 + holidays
FB_tbl <- FANG \%>\% filter(symbol == "FB")

holidays <- tk_make_holiday_sequence(
    start_date = "2017-01-01",
    end_date   = "2017-12-31",
    calendar   = "NYSE")

# Remove holidays with skip_values, and remove weekends with inspect_weekdays = TRUE
FB_tbl \%>\%
    tk_index() \%>\%
    tk_make_future_timeseries(n_future         = "1 year",
                              inspect_weekdays = TRUE,
                              skip_values      = holidays)




}
\seealso{
\itemize{
\item Making Time Series: \code{\link[=tk_make_timeseries]{tk_make_timeseries()}}
\item Working with Holidays: \code{\link[=tk_make_holiday_sequence]{tk_make_holiday_sequence()}}
\item Working with Timestamp Index: \code{\link[=tk_index]{tk_index()}}, \code{\link[=tk_get_timeseries_summary]{tk_get_timeseries_summary()}}, \code{\link[=tk_get_timeseries_signature]{tk_get_timeseries_signature()}}
}
}
