% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.parsamp.timedeppar.R
\name{get.parsamp}
\alias{get.parsamp}
\title{Get a sample of lists of constant and time-dependent parameters from inference results of \code{infer.timedeppar}}
\usage{
get.parsamp(x, samp.size = 1000, n.burnin = 0, times.new = numeric(0))
}
\arguments{
\item{x}{results from the function \code{infer.timedeppar} of class \code{timedeppar}.}

\item{samp.size}{size of the produced sample constructed from the Markov chain stored in the
object of class \code{timedeppar} omitting the adaptation and burnin phases.}

\item{n.burnin}{number of Markov chain points to omit for density and pairs plots
(number of omitted points is max(control$n.adapt,n.burnin)).}

\item{times.new}{vector of time points to predict for.
If no time points are provided, sampling is only from the inference Markov chain;
if time points are provided, they need to be increasing and start with a larger value 
than the time points used for inference.
In the latter case, time-dependent parameters are sampled for the future points and
appended to the inferred part of the time-dependend parameter.}
}
\value{
list of\cr
        \code{param.maxpost}:   list of constant and time-dependent parameters corresponding to the maximum posterior
                                solution for inference (no extrapolation to the future).\cr
        \code{param.maxlikeli}: list of constant and time-dependent parameters corresponding to the solution with
                                maximum observation likelihood found so far.\cr
        \code{param.list}:      list of length \code{samp.size} containing lists of constant and time-dependent parameters;
                                for time-dependent parameters sub-sample of the Markov chain for past time points, 
                                sample from Ornstein-Uhlenbeck processes conditioned at the initial point for future
                                time points (see argument \code{times.new}).\cr
        \code{param.const}:     sub-sample of constant parameters.\cr
        \code{param.timedep}:   list of sub-samples of time-dependent parameters.\cr
        \code{param.ou}:        sub-sample of Ornstein-Uhlebeck parameters of the time-dependent parameter(s).\cr
        \code{ind.timedeppar}:  indices of time-dependent parameters in the parameter lists.\cr
        \code{ind.sample}:      indices of the stored, thinned sample defining the sub-sample.\cr
        \code{ind.chain}:       indices of the original non-thinned Markov chain defining the sub-sample.\cr
        \code{dot.args}:        ... arguments passed to \code{\link{infer.timedeppar}}; to be re-used for new
                                model evaluations.\cr
}
\description{
This function produces a sample of parameter sets for past and potentially future time points based on the results of
class \code{timedeppar} generated by Bayesian inference with the function \code{infer.timedeppar}.
For time points used for inference, the sample is a sub-samble of the Markov chain, for future time points of 
time-dependent parameters it is a random sample based on the corresponding Ornstein-Uhlenbeck parameters and 
constrained at there initial point to the end point of the sub-sample.
}
