% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taper_bi.R
\name{taper_bi}
\alias{taper_bi}
\title{Bi (2004) Taper Function.}
\usage{
taper_bi(dbh, h, hih, b0, b1, b2, b3, b4, b5, b6)
}
\arguments{
\item{dbh}{tree diameter at breast height, in centimeters.}

\item{h}{total tree height, in meters.}

\item{hih}{ratio between the height of the section (hi) and the total height (h) .}

\item{b0, b1, b2, b3, b4, b5, b6}{model parameters.}
}
\value{
a numeric value indicating the diameter at the section.
}
\description{
Bi (2004) Taper Function.
}
\examples{

library(dplyr)
library(minpack.lm)
library(timbeR)

tree_scaling <- tree_scaling \%>\%
mutate(did = di/dbh,
       hih = hi/h)

bi <-  nlsLM(di ~ taper_bi(dbh, h, hih, b0, b1, b2, b3, b4, b5, b6),
data=tree_scaling,
start=list(b0=1.8,b1=-0.2,b2=-0.04,b3=-0.9,b4=-0.0006,b5=0.07,b6=-.14))

}
\references{
Bi, H. (2000). Trigonometric variable-form taper equations for Australian eucalypts. Forest Science, 46(3), 397-409.
}
