% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kozak_di.R
\name{kozak_di}
\alias{kozak_di}
\title{Estimate the diameter at a given height based on a fitted Kozak (2004) taper equation.}
\usage{
kozak_di(dbh, h, hi, coef, p)
}
\arguments{
\item{dbh}{tree diameter at breast height, in centimeters.}

\item{h}{total tree height, in meters.}

\item{hi}{height at which the diameter will be calculated, in meters.}

\item{coef}{numerical vector containing nine coefficients of the Kozak taper function.}

\item{p}{numerical value representing the first inflection point calculated in the segmented model of Max and Burkhart (1976).}
}
\value{
a numeric value indicating the diameter at the given height.
}
\description{
Estimates the diameter at a given height of a tree from the diameter at breast height, total height and the coefficients of the Kozak (2004) taper function.
}
\details{
the Kozak (2004) variable-form taper function is represented mathematically by the following expression

di ~b0*(dbh^b1)\emph{(h^b2)}((1-(hi/h)^(1/4))/(1-(p^(1/3))))^(b3*(hi/h)^4+b4*(1/exp(dbh/h))+b5*((1-(hi/h)^(1/4))/(1-(p^(1/3))))^0.1+b6*(1/dbh)+b7*(h^(1-(hi/h)^(1/3)))+b8*((1-(hi/h)^(1/4))/(1-(p^(1/3)))))
}
\examples{

library(dplyr)
library(minpack.lm)
library(timbeR)

tree_scaling <- tree_scaling \%>\%
mutate(did = di/dbh,
       hih = hi/h)

kozak <- nlsLM(di ~ taper_kozak(dbh, h, hih, b0, b1, b2, b3, b4, b5, b6, b7, b8, p),
               start=list(b0=1.00,b1=.97,b2=.03,b3=.49,b4=-
                            0.87,b5=0.50,b6=3.88,b7=0.03,b8=-0.19, p = .1),
               data = tree_scaling,
               control = nls.lm.control(maxiter = 1000, maxfev = 2000)
)

coef_kozak <- coef(kozak)[-10]
p_kozak <- coef(kozak)[10]

h <- 20
dbh <- 25
di <- 5

kozak_di(dbh, h, di, coef_kozak, p_kozak)

}
