% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataFrame.R
\name{fromDataFrame}
\alias{fromDataFrame}
\title{Create a TileDB Dense Array from a given \code{data.frame} Object}
\usage{
fromDataFrame(obj, uri)
}
\arguments{
\item{obj}{A \code{data.frame} object.}

\item{uri}{A character variable with an Array URI.}
}
\value{
Null, invisibly.
}
\description{
The supplied \code{data.frame} object is (currently) limited to integer,
numeric, or character columns.
}
\details{
The create (Dense) Array will have as many attributes as there are columns in
the \code{data.frame}.  Each attribute will be a single column.

At present, factor variable are converted to character.
}
\examples{
\dontshow{ctx <- tiledb_ctx(limitTileDBCores())}
\dontrun{
uri <- tempfile()
## turn factor into character
irisdf <- within(iris, Species <- as.character(Species))
fromDataFrame(irisdf, uri)
arr <- tiledb_dense(uri, as.data.frame=TRUE)
newdf <- arr[]
all.equal(iris, newdf)
}
}
