% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utils.R
\name{save_allocation_size_preference}
\alias{save_allocation_size_preference}
\alias{load_allocation_size_preference}
\alias{get_allocation_size_preference}
\alias{set_allocation_size_preference}
\title{Store allocation size preference}
\usage{
save_allocation_size_preference(value)

load_allocation_size_preference()

get_allocation_size_preference()

set_allocation_size_preference(value)
}
\arguments{
\item{value}{A numeric value with the desired allocation size (in bytes).}
}
\value{
For the setter, \code{TRUE} is returned invisibly but the function is invoked for the
side effect of storing the value. For the getters, the value as a numeric.
}
\description{
Save (or load) allocation size default preference in an optional
config file
}
\details{
When retrieving data from sparse arrays, allocation sizes cannot
be determined \emph{ex ante} as the degree of sparsity is unknown.
A configuration value can aide in providing an allocation size
value. These functions let the user store such a value for
retrieval by the package code.  The preference will be enconded in
a configuration file as R (version 4.0.0 or later) allows a user-
and package specific configuration files.  These helper functions
sets and retrieve the value, respectively, or retrieve the cached
value from the package environment where is it set at package
load.

The value will be stored as a character value and reparsed so
\sQuote{1e6} and \sQuote{1000000} are equivalent, and the fixed
(but adjustable) number of digits for numerical precision
\emph{use for formatting} will impact the writing. This should
have no effect on standard allocation sizes.

Note that this memory budget (currently, at least) applies only to
character columns.  A fallback value of 50mb is used if no user
value is set, and is used for all columns (rather than per column).
}
\note{
This function requires R version 4.0.0 or later to utilise the per-user
config directory accessor function. For older R versions, a fallback from the
TileDB configuration object is used.
}
