% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr-like.R
\name{contingency_table_by}
\alias{contingency_table_by}
\title{Create data frame formed like a contingency-table}
\usage{
contingency_table_by(.tbl, var1, var2, na.rm = F, add_margins = F)
}
\arguments{
\item{.tbl}{A data frame}

\item{var1}{First column to count by}

\item{var2}{Second column to count by}

\item{na.rm}{Shall NA values be removed prior to counting?}

\item{add_margins}{Add row- and column wise margins as extra column and row}
}
\value{
A data frame
}
\description{
Counts by the specified two variables and the pivots the
count data frame wider to a two-dimensional contingency table.
Please note that the resulting data frame is suitable for convenient
output or use with functions that work on matrix-like data,
but does not fulfill the tidy data criteria.
}
\examples{
library(magrittr)
if (requireNamespace("datasets", quietly = TRUE))
{
   mtcars \%>\% contingency_table_by(cyl, gear)
}
}
