% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/na.R
\name{which_non_na}
\alias{which_non_na}
\title{Get indices of non-NA values}
\usage{
which_non_na(...)
}
\arguments{
\item{...}{k vectors of the same length n, regarded as k columns with each n rows}
}
\value{
A list of n numerical vectors. Each numerical vector has a size between 0 and k and contains the
        indices of the vectors whose elements are not na in the corresponding row.
}
\description{
Get indices of non-NA values
}
\examples{
library(tibble)
library(magrittr)
library(dplyr)
# Creates a list column containing (2,3);(3);(1,2,3)
tibble(a=c(NA, NA, 2), b=c(4, NA, 5), c=c(1, 2, 3)) \%>\%
  mutate(non_na_idc=which_non_na(a, b, c))
}
