% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count.R
\name{count.}
\alias{count.}
\title{Count observations by group}
\usage{
count.(.df, ..., wt = NULL, sort = FALSE, name = NULL)
}
\arguments{
\item{.df}{A data.frame or data.table}

\item{...}{Columns to group by. \code{tidyselect} compatible.}

\item{wt}{Frequency weights.  \code{tidyselect} compatible.
Can be \code{NULL} or a variable:
\itemize{
\item If \code{NULL} (the default), counts the number of rows in each group.
\item If a variable, computes \code{sum(wt)} for each group.
}}

\item{sort}{If \code{TRUE}, will show the largest groups at the top.}

\item{name}{The name of the new column in the output.

If omitted, it will default to \code{n}.}
}
\description{
Returns row counts of the dataset. If bare column names are provided, \code{count.()} returns counts by group.
}
\examples{
df <- data.table(
  x = 1:3,
  y = 4:6,
  z = c("a", "a", "b")
)

df \%>\%
  count.()

df \%>\%
  count.(z)

df \%>\%
  count.(where(is.character))

df \%>\%
  count.(z, wt = y, name = "y_sum")

df \%>\%
  count.(z, sort = TRUE)
}
