% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coalesce.R
\name{coalesce.}
\alias{coalesce.}
\title{Coalesce missing values}
\usage{
coalesce.(..., .ptype = NULL, .size = NULL)
}
\arguments{
\item{...}{Input vectors. Supports dynamic dots.}

\item{.ptype}{Optional ptype to override output type}

\item{.size}{Optional size to override output size}
}
\description{
Fill in missing values in a vector by pulling successively from other vectors.
}
\examples{
# Use a single value to replace all missing values
x <- c(1:3, NA, NA)
coalesce.(x, 0)

# Or match together a complete vector from missing pieces
y <- c(1, 2, NA, NA, 5)
z <- c(NA, NA, 3, 4, 5)
coalesce.(y, z)

# Supply lists with dynamic dots
vecs <- list(
  c(1, 2, NA, NA, 5),
  c(NA, NA, 3, 4, 5)
)
coalesce.(!!!vecs)
}
