% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count.R
\name{count.}
\alias{count.}
\alias{dt_count}
\title{Count observations by group}
\usage{
count.(.df, ...)

dt_count(.df, ...)
}
\arguments{
\item{.df}{A data.frame or data.table}

\item{...}{Columns to group by. \code{tidyselect} compatible.}
}
\description{
Returns row counts of the dataset. If bare column names are provided, \code{count.()} returns counts by group.
}
\examples{
test_df <- data.table(
  x = 1:3,
  y = 4:6,
  z = c("a", "a", "b"))

test_df \%>\%
  count.()

test_df \%>\%
  count.(z)

test_df \%>\%
  count.(where(is.character))
}
