% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pivot_wider.R
\name{dt_pivot_wider}
\alias{dt_pivot_wider}
\title{Pivot data from long to wide}
\usage{
dt_pivot_wider(
  .data,
  id_cols = NULL,
  names_from,
  names_sep = "_",
  values_from,
  drop = TRUE
)
}
\arguments{
\item{.data}{the data table to widen}

\item{id_cols}{A set of columns that uniquely identifies each observation. Defaults to all columns in the data table except for the columns specified in \code{names_from} and \code{values_from}. Typically used when you have additional variables that is directly related.}

\item{names_from}{A pair of arguments describing which column (or columns) to get the name of the output column (\code{name_from}), and which column (or columns) to get the cell values from (\code{values_from}).}

\item{names_sep}{the separator between the names of the columns}

\item{values_from}{A pair of arguments describing which column (or columns) to get the name of the output column (\code{name_from}), and which column (or columns) to get the cell values from (\code{values_from}).}

\item{drop}{When \code{FALSE}, will cast by including all missing combinations. When \code{TRUE}, it is drop missing combination. \code{c(FALSE, TRUE)} will only include all missing combinations of formula LHS; \code{c(TRUE, FALSE)} will only include all missing combinations of formula RHS.}
}
\description{
\code{dt_pivot_wider()} "widens" data, increasing the number of columns and
decreasing the number of rows. The inverse transformation is
\code{dt_pivot_longer()}. Syntax based on the \code{tidyr} equivalents.

Supports enhanced selection
}
\examples{

library(data.table)

example_dt <- data.table::data.table(
  z = rep(c("a", "b", "c"), 2),
  stuff = c(rep("x", 3), rep("y", 3)),
  things = 1:6)

dt_pivot_wider(example_dt, names_from = stuff, values_from = things)
dt_pivot_wider(example_dt, names_from = stuff, values_from = things, id_cols = z)

}
