test_that("collapse_comments works scalars", {
  expect_identical(collapse_comments("x"), "x.")
  expect_identical(collapse_comments(""), "")
  expect_identical(collapse_comments(NA_character_), "")
  expect_identical(collapse_comments(character(0)), character(0))
})

test_that("collapse_comments works vectors", {
  expect_identical(collapse_comments("x", "y"), "x. y.")
  expect_identical(collapse_comments("x", ""), "x.")
  expect_identical(collapse_comments("x", NA_character_), "x.")
  expect_identical(collapse_comments("x", character(0)), "x.")
  expect_identical(collapse_comments("", "x"), "x.")
  expect_identical(collapse_comments(NA_character_, "x"), "x.")
  expect_identical(collapse_comments(character(0), "x"), "x.")
  expect_identical(collapse_comments(NA_character_, NA_character_), "")
  expect_identical(collapse_comments(character(0), character(0)), character(0))
})

test_that("collapse_comments handles .", {
  expect_identical(collapse_comments("x."), "x.")
  expect_identical(collapse_comments("x", "y"), "x. y.")
  expect_identical(collapse_comments("x.", "y"), "x. y.")
  expect_identical(collapse_comments("x.", "y."), "x. y.")
  expect_identical(collapse_comments("x.", "y.."), "x. y.")
  expect_identical(collapse_comments("x", NA_character_), "x.")
  expect_identical(collapse_comments("x.", NA_character_), "x.")
  expect_identical(collapse_comments(NA_character_, "x"), "x.")
  expect_identical(collapse_comments(NA_character_, "x."), "x.")
})

test_that("collapse_comments strips spaces", {
  expect_identical(collapse_comments("x. "), "x.")
  expect_identical(collapse_comments("     x   y. "), "x y.")
  expect_identical(collapse_comments(".     x   y. "), ". x y.")
  expect_identical(collapse_comments("z", ".     x   y. "), "z. . x y.")
  expect_identical(collapse_comments("x ."), "x.")
  expect_identical(collapse_comments(".", "x"), "x.")
  expect_identical(collapse_comments(". .", "x"), "x.")
  expect_identical(collapse_comments("x . "), "x.")
  expect_identical(collapse_comments(" x  "), "x.")
  expect_identical(collapse_comments("x. y"), "x. y.")
  expect_identical(collapse_comments("x.", "y. ."), "x. y.")
  expect_identical(collapse_comments("x.", "y  . ."), "x. y.")
  expect_identical(collapse_comments("x. ."), "x.")
})
