% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geocode.R
\name{geocode}
\alias{geocode}
\title{Geocode addresses in a dataframe}
\usage{
geocode(
  .tbl,
  address = NULL,
  street = NULL,
  city = NULL,
  county = NULL,
  state = NULL,
  postalcode = NULL,
  country = NULL,
  lat = lat,
  long = long,
  return_input = TRUE,
  limit = 1,
  return_addresses = NULL,
  unique_only = FALSE,
  ...
)
}
\arguments{
\item{.tbl}{dataframe containing addresses}

\item{address}{single line street address column name. Do not combine with
address component arguments (street, city, county, state, postalcode, country)}

\item{street}{street address column name}

\item{city}{city column name}

\item{county}{county column name}

\item{state}{state column name}

\item{postalcode}{postalcode column name (zip code if in the United States)}

\item{country}{country column name}

\item{lat}{latitude column name. Can be quoted or unquoted (ie. lat or 'lat').}

\item{long}{longitude column name. Can be quoted or unquoted (ie. long or 'long').}

\item{return_input}{if TRUE then the input dataset will be combined with the geocoder query results
and returned. If FALSE only the geocoder results will be returned.}

\item{limit}{maximum number of results to return per input address. For many geocoder services
the maximum value of the limit parameter is 100. Pass \code{limit = NULL} to use
the default \code{limit} value of the selected geocoder service.
For batch geocoding, limit must be set to 1 (default) if \code{return_addresses = TRUE}.
To use \code{limit > 1} or \code{limit = NULL} set return_input to FALSE.
Refer to \link{api_parameter_reference} for more details.}

\item{return_addresses}{if TRUE return input addresses. Defaults to TRUE if \code{return_input} is FALSE
and FALSE if \code{return_input} is TRUE. This argument is passed to the \code{geo()} function.}

\item{unique_only}{if TRUE then only unique results will be returned and
return_input will be set to FALSE.}

\item{...}{arguments passed to the \link{geo} function}
}
\value{
tibble (dataframe)
}
\description{
Takes a dataframe containing addresses as an input and returns
the results from a specified geocoder service in a dataframe format using the
\link{geo} function. See example usage in \code{vignette("tidygeocoder")}.

This function passes all additional parameters (\code{...}) to the
\link{geo} function, so you can refer to its documentation for more details
on possible arguments.

Note that the arguments used for specifying address columns (address,
street, city, county, state, postalcode, and country) accept either
quoted or unquoted column names (ie. "address_col" and address_col are
both acceptable).
}
\examples{
\donttest{
library(dplyr)
sample_addresses \%>\% slice(1:2) \%>\%
 geocode(addr, method = 'arcgis')

louisville \%>\% head(2) \%>\%
 geocode(street = street, city = city, state = state,
  postalcode = zip, method = 'census', full_results = TRUE)

sample_addresses \%>\% slice(8:9) \%>\%
 geocode(addr, method = 'osm', limit = 2,
  return_input = FALSE, full_results = TRUE)

sample_addresses \%>\% slice(4:5) \%>\%
 geocode(addr, method = 'arcgis',
  lat = latitude, long = longitude,
  full_results = TRUE)
}
}
\seealso{
\link{geo}
}
