% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arrange.R
\name{arrange}
\alias{arrange}
\title{Arrange entries in data.frame}
\usage{
arrange(.data, ..., cols = NULL, order = 1L)
}
\arguments{
\item{.data}{data.frame}

\item{...}{Arrange by what group? Minus symbol means arrange by
descending order.}

\item{cols}{For \code{set_arrange} only.
A character vector of column names of \code{.data} by which to order.
If present, override \code{...}. Defaults to \code{NULL}.}

\item{order}{For \code{set_arrange} only. An integer vector with only possible
values of 1 and -1, corresponding to ascending and descending order.
Defaults to 1.}
}
\value{
A data.table
}
\description{
Analogous function for \code{arrange} in \pkg{dplyr}.
}
\details{
Once arranged, the order of entries would be changed forever.
}
\examples{

a = as.data.table(iris)
a \%>\% arrange(Sepal.Length)
a
a \%>\% arrange(cols = c("Sepal.Width","Petal.Length"))
a

}
\seealso{
\code{\link[dplyr]{arrange}}, \code{\link[data.table]{setorder}}
}
