% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slice.R
\name{slice_dt}
\alias{slice_dt}
\alias{slice_head_dt}
\alias{slice_tail_dt}
\alias{slice_max_dt}
\alias{slice_min_dt}
\alias{slice_sample_dt}
\title{Subset rows using their positions}
\usage{
slice_dt(.data, ..., by = NULL)

slice_head_dt(.data, n, by = NULL)

slice_tail_dt(.data, n, by = NULL)

slice_max_dt(.data, order_by, n, by = NULL, with_ties = TRUE)

slice_min_dt(.data, order_by, n, by = NULL, with_ties = TRUE)

slice_sample_dt(.data, n, replace = FALSE, by = NULL)
}
\arguments{
\item{.data}{A data.table}

\item{...}{Provide either positive values to keep, or negative values to drop.
The values provided must be either all positive or all negative.}

\item{by}{Slice by which group(s)?}

\item{n}{When larger than or equal to 1, the number of rows.
When between 0 and 1, the proportion of rows to select.}

\item{order_by}{Variable or function of variables to order by.}

\item{with_ties}{Should ties be kept together? The default, `TRUE`,
may return more rows than you request. Use `FALSE` to ignore ties,
and return the first `n` rows.}

\item{replace}{Should sampling be performed with (`TRUE`) or without
(`FALSE`, the default) replacement.}
}
\value{
A data.table
}
\description{
`slice_dt()` lets you index rows by their (integer) locations. It allows you
to select, remove, and duplicate rows. It is accompanied by a number of
helpers for common use cases:

* `slice_head_dt()` and `slice_tail_dt()` select the first or last rows.
* `slice_sample_dt()` randomly selects rows.
* `slice_min_dt()` and `slice_max_dt()` select rows with highest or lowest values
  of a variable.
}
\examples{

a = iris
slice_dt(a,1,2)
slice_dt(a,2:3)
slice_dt(a,141:.N)
slice_dt(a,1,.N)
slice_head_dt(a,5)
slice_head_dt(a,0.1)
slice_tail_dt(a,5)
slice_tail_dt(a,0.1)
slice_max_dt(a,Sepal.Length,10)
slice_max_dt(a,Sepal.Length,10,with_ties = FALSE)
slice_min_dt(a,Sepal.Length,10)
slice_min_dt(a,Sepal.Length,10,with_ties = FALSE)
slice_sample_dt(a,10)
slice_sample_dt(a,0.1)


# use by to slice by group

## following codes get the same results
slice_dt(a,1:3,by = "Species")
slice_dt(a,1:3,by = Species)
slice_dt(a,1:3,by = .(Species))

slice_head_dt(a,2,by = Species)
slice_tail_dt(a,2,by = Species)

slice_max_dt(a,Sepal.Length,3,by = Species)
slice_max_dt(a,Sepal.Length,3,by = Species,with_ties = FALSE)
slice_min_dt(a,Sepal.Length,3,by = Species)
slice_min_dt(a,Sepal.Length,3,by = Species,with_ties = FALSE)

# in `slice_sample_dt`, "by" could only take character class
slice_sample_dt(a,.1,by = "Species")
slice_sample_dt(a,3,by = "Species")
slice_sample_dt(a,51,replace = TRUE,by = "Species")

}
\seealso{
\code{\link[dplyr]{slice}}
}
