% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/categorical.R, R/correlation.R, R/describe.R,
%   R/regression.R, R/tab_percentiles.R, R/tdcmm_class.R, R/ttest.R,
%   R/unianova.R
\name{visualize.tdcmm_ctgrcl}
\alias{visualize.tdcmm_ctgrcl}
\alias{visualize.tdcmm_crrltn}
\alias{visualize.tdcmm_dscrb}
\alias{visualize.tdcmm_rgrssn}
\alias{visualize.tdcmm_prcntl}
\alias{visualize}
\alias{visualize.tdcmm_ttst}
\alias{visualize.tdcmm_nnv}
\title{Visualize tidycomm output}
\usage{
\method{visualize}{tdcmm_ctgrcl}(x, ..., .design = design_lmu())

\method{visualize}{tdcmm_crrltn}(x, which = "jitter", ..., .design = design_lmu())

\method{visualize}{tdcmm_dscrb}(x, ..., .design = design_lmu())

\method{visualize}{tdcmm_rgrssn}(x, which = "jitter", ..., .design = design_lmu())

\method{visualize}{tdcmm_prcntl}(x, ..., .design = design_lmu())

visualize(x, ..., .design = design_lmu())

\method{visualize}{tdcmm_ttst}(x, ..., .design = design_lmu())

\method{visualize}{tdcmm_nnv}(x, ..., .design = design_lmu())
}
\arguments{
\item{x}{\code{tdcmm} output}

\item{...}{other arguments}

\item{.design}{a list to style the visualization; by default and good practice
use one of the ready-made design functions' returns (e.g., \code{design_lmu()},
\code{design_grey()}); you could, however, also provide your own list here which
has to be a list with 9 keys: \code{main_color_1}, a vector of 12 \code{main_colors}, a
corresponding \code{main_contrast_1} (the color of text to write on top of the
main color) and a corresponding \code{main_contrasts}, the \code{main_size} (for
lines), a \code{comparison_linetype}, \code{comparison_color}, and \code{comparison_size}
for all lines that act as comparative lines, and a \link{ggplot2} \code{theme}}

\item{which}{string to specify type of regression visualization. One of
"jitter" (default), "alpha", "correlogram", "residualsfitted" (or "resfit"),
"pp", "qq", "scalelocation" (or "scaloc"), "residualsleverage" (or "reslev").
See below for details.}
}
\value{
A \link{ggplot2} object
}
\description{
Returns \link{ggplot2} visualization appropriate to respective \code{tdcmm} model
(see list below). Returns \code{NULL} (and a warning) if no visualization has
been implemented for the particular model.
}
\details{
\itemize{
\item \code{\link[=describe]{describe()}}: horizontal box plot depicting a box from Q25 to Q75, a thick
line for Mdn, and two whiskers to Min/Max respectively;
no additional arguments
\item \code{\link[=describe_cat]{describe_cat()}}: horizontal bar plot depicting number of occurrences;
no additional arguments
\item \code{\link[=tab_frequencies]{tab_frequencies()}}: either a histogram (if 1 variable is given) or
multiple histograms wrapped, 5+ variables issue a warning about readability;
no additional arguments
\item \code{\link[=tab_percentiles]{tab_percentiles()}}: quantile plot
\item \code{\link[=crosstab]{crosstab()}}: horizontal stacked bar plot, either absolute or relative
(depending on the \code{percentages} argument in \code{\link[=crosstab]{crosstab()}})
\item \code{\link[=t_test]{t_test()}}: plot with points and appended 95\% confidence intervals;
no additional arguments
\item \code{\link[=unianova]{unianova()}}: plot with points and appended 95\% confidence intervals;
no additional arguments
\item \code{\link[=correlate]{correlate()}}: plot as scatter; for more than 2 variables, a correlogram
is plotted (just like for \code{\link[=to_correlation_matrix]{to_correlation_matrix()}}); use the \code{which}
parameter to select how points are visualized:
\itemize{
\item "jitter" adds a bit of random noise to each point to better reflect
categorical values
\item "alpha" depicts points slightly transparent so that multiple points in
the same position are more easily visible
}
\item \code{\link[=correlate]{correlate()}}: for partial correlation, a scatter plot with some jitter is
plotted using the residuals between the control variable and (a) the
dependent as well as (b) the independent variable; no additional arguments
\item \code{\link[=to_correlation_matrix]{to_correlation_matrix()}}: plot as correlogram building on
\code{\link[GGally:ggpairs]{GGally::ggpairs()}} with jittered scatter plots in lower half, histograms as
diagonals, and correlation coefficients with 95\% confidence intervals in
upper half
\item \code{\link[=regress]{regress()}}: plot regression results as scatter (without jitter) and an
additional depicted model line with including its 95\% confidence intervals;
alternatively, visual check inspection helpers can be plotted through the
\code{which} parameter which can be set to yield one of the following:
\itemize{
\item "jitter" (default): plots a scatter plot with jitter per independent
variable and adds a linear regression line with 95\% confidence intervals
to it; keep in mind that if you have, say, three independent variables,
this visualization shows you three plots with one linear regression for
each, so that the three models (i.e., the three colored lines) reflect
only the particular combination of one independent and the dependent
variable
\item "alpha" (default): almost like \code{jitter} but instead of jitter it plots
scatter plots with some transparency so that multiple data points in the
same position appear as darker
\item "correlogram": like \code{\link[=to_correlation_matrix]{to_correlation_matrix()}}, a correlogram between
independent variables are produced to help determine independent errors
and multicollinearity
\item "residualsfitted" or "resfit": a residuals-versus-fitted plot is useful
to determine distributions; for a normal distribution the colored line
should ideally fit on the dashed line
\item "pp": a (normal) probability-probability plot helps checking for
multicollinearity whereby the data (here mostly the center data from
within the IQR) should ideally align with the dashed line
\item "qq": a (normal) quantile-quantile plot helps checking for
multicollinearity but focuses more on outliers; the data should align with
the dashed line
\item "scalelocation" or "scaloc": a scale-location (sometimes also called a
spread-location) plot checks whether residuals are spread equally to help
check for homoscedasticity; ideally, the colored line is horizontal and
the data spreads more or less randomly
\item "residualsleverage" or "reslev": a residuals-versus-leverage plot allows
to check for influential outliers affecting the final model more than the
rest of the data; ideally, no data is far off compared to the bulk of the
the data and thus shows high Cook's distance to the rest; the colored line
helps to identify the bulk of the data and the five most-distant outliers
are labelled with their case number (i.e., the row number in the dataset);
note that 5 is arbitrary here, meaning that they might not be too far off
or there might be more than 5 noteworthy outliers in this model; interpret
with care
}
}

Note that the returned \link{ggplot2} object can be modified easily by appending
or overwriting individual geom's or scale's. See the examples below and the
documentation of \link{ggplot2}.
}
\examples{
\dontrun{
WoJ \%>\%
  describe() \%>\%
  visualize()

fbposts \%>\%
  describe_cat() \%>\%
  visualize()

WoJ \%>\%
  tab_frequencies(trust_parliament) \%>\%
  visualize()
fbposts \%>\%
  tab_frequencies(pop_elite, pop_people, pop_othering) \%>\%
  visualize()

WoJ \%>\%
  crosstab(reach, employment) \%>\%
  visualize()

fbposts \%>\%
  crosstab(coder_id, type, percentages = TRUE) \%>\%
  visualize()

WoJ \%>\%
  t_test(temp_contract, autonomy_selection, autonomy_emphasis) \%>\%
  visualize()

WoJ \%>\%
  unianova(country, autonomy_selection, autonomy_emphasis) \%>\%
  visualize()

fbposts \%>\%
  correlate(pop_elite, pop_people) \%>\%
  visualize()

fbposts \%>\%
  correlate(pop_elite, pop_people, with = pop_othering) \%>\%
  visualize()

fbposts \%>\%
  correlate(pop_elite, pop_people) \%>\%
  visualize("alpha")

WoJ \%>\%
  correlate(autonomy_selection, ethics_1, partial = work_experience) \%>\%
  visualize()

WoJ \%>\%
  correlate(ethics_1, ethics_2, ethics_3, ethics_4) \%>\%
  to_correlation_matrix() \%>\%
  visualize()

r <- WoJ \%>\% regress(autonomy_selection, temp_contract, work_experience, ethics_2)
r \%>\% visualize() # same as r \%>\% visualize("jitter")
r \%>\% visualize("alpha")
r \%>\% visualize("correlogram")
r \%>\% visualize("resfit")
r \%>\% visualize("pp")
r \%>\% visualize("qq")
r \%>\% visualize("scaloc")
r \%>\% visualize("reslev")

# To overwrite a certain scale or geom, just append as you would with ggplot2
fbposts \%>\%
  describe_cat() \%>\%
  visualize() +
    ggplot2::scale_fill_grey()
}

}
\concept{visualize}
