% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metric-silhouette.R
\name{silhouette_avg}
\alias{silhouette_avg}
\alias{silhouette_avg.cluster_spec}
\alias{silhouette_avg.cluster_fit}
\alias{silhouette_avg.workflow}
\alias{silhouette_avg_vec}
\title{Measures average silhouette across all observations}
\usage{
silhouette_avg(object, ...)

\method{silhouette_avg}{cluster_spec}(object, ...)

\method{silhouette_avg}{cluster_fit}(object, new_data = NULL, dists = NULL, dist_fun = NULL, ...)

\method{silhouette_avg}{workflow}(object, new_data = NULL, dists = NULL, dist_fun = NULL, ...)

silhouette_avg_vec(
  object,
  new_data = NULL,
  dists = NULL,
  dist_fun = Rfast::Dist,
  ...
)
}
\arguments{
\item{object}{A fitted kmeans tidyclust model}

\item{...}{Other arguments passed to methods.}

\item{new_data}{A dataset to predict on.  If \code{NULL}, uses trained clustering.}

\item{dists}{A distance matrix. Used if \code{new_data} is \code{NULL}.}

\item{dist_fun}{A function for calculating distances between observations.
Defaults to Euclidean distance on processed data.}
}
\value{
A double; the average silhouette.
}
\description{
Measures average silhouette across all observations
}
\details{
Not to be confused with \code{\link[=silhouette]{silhouette()}} that returns a tibble
with silhouette for each observation.
}
\examples{
kmeans_spec <- k_means(num_clusters = 5) \%>\%
  set_engine("stats")

kmeans_fit <- fit(kmeans_spec, ~., mtcars)

dists <- mtcars \%>\%
  as.matrix() \%>\%
  dist()

silhouette_avg(kmeans_fit, dists = dists)

silhouette_avg_vec(kmeans_fit, dists = dists)
}
\seealso{
Other cluster metric: 
\code{\link{sse_ratio}()},
\code{\link{sse_total}()},
\code{\link{sse_within_total}()}
}
\concept{cluster metric}
