% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mx_mixture.R
\name{mx_growth_mixture}
\alias{mx_growth_mixture}
\title{Estimate growth mixture models using OpenMx}
\usage{
mx_growth_mixture(model, classes = 1L, data = NULL, run = TRUE, ...)
}
\arguments{
\item{model}{Syntax for the model; either a character string, or a list of
character strings, or a list of \code{mxModel} objects. See Details.}

\item{classes}{A vector of integers, indicating which class solutions to
generate. Defaults to 1L. E.g., \code{classes = 1:6},
\code{classes = c(1:4, 6:8)}.}

\item{data}{The data.frame to be used for model fitting.}

\item{run}{Logical, whether or not to run the model. If \code{run = TRUE},
the function calls \code{\link{mixture_starts}} and \code{\link{run_mx}}.}

\item{...}{Additional arguments, passed to functions.}
}
\value{
Returns an \code{\link[OpenMx]{mxModel}}.
}
\description{
This function is a wrapper around \code{\link{mx_mixture}}, adding the
default arguments of \code{\link[lavaan]{growth}} to simplify the
specification of growth mixture models. This function is only
useful if all the latent variables in the model are growth factors.
}
\examples{
\dontrun{
data("empathy")
df <- empathy[1:6]
mx_growth_mixture(model = "i =~ 1*ec1 + 1*ec2 + 1*ec3 +1*ec4 +1*ec5 +1*ec6
                           s =~ 0*ec1 + 1*ec2 + 2*ec3 +3*ec4 +4*ec5 +5*ec6
                           ec1 ~~ vec1*ec1
                           ec2 ~~ vec2*ec2
                           ec3 ~~ vec3*ec3
                           ec4 ~~ vec4*ec4
                           ec5 ~~ vec5*ec5
                           ec6 ~~ vec6*ec6
                           i ~~ 0*i
                           s ~~ 0*s
                           i ~~ 0*s",
                  classes = 2,
                  data = df) -> res
}
}
\keyword{mixture}
\keyword{models}
\keyword{openmx}
