% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/three_mode_pca.R
\name{three_mode}
\alias{three_mode}
\title{Create Three Mode PCA and PCoA plots}
\usage{
three_mode(
  micro_set,
  table,
  group,
  time_var,
  subject,
  y = clr,
  plot_scores = F,
  main = NULL,
  subtitle = NULL,
  legend_title = NULL,
  scalewt = TRUE
)
}
\arguments{
\item{micro_set}{A tidy_micro data set}

\item{table}{OTU table of interest}

\item{group}{A categorical variable to color by}

\item{time_var}{The time point variable column name in your tidi_MIBI set}

\item{subject}{The subject variable column name in your tidi_MIBI set}

\item{y}{Value to calculate principle components or coordinates on. Default is centered log ratio (recommended)}

\item{plot_scores}{Plot the scores instead of the principle components}

\item{main}{Plot title}

\item{subtitle}{Plot subtitle}

\item{legend_title}{Plot legend title}

\item{scalewt}{Logical; center and scale OTU table, recommended}
}
\value{
A ggplot you can add geoms to if you'd like
}
\description{
Three Mode Principal Components, an ordination method that can take into account repeated measure of subjects. These methods have also been extended to other common ecological distance metrics for Three Mode Principal Coordinate Analysis
}
\details{
Requires that you have columns for subject name and time point. Data must be complete across time points. The function will filter out inconsistent subjects

If n_compA, n_compB, and n_compC aren't specified they will default to the number of complete subjects, the number of taxa, and the number of time points, respectively. This slows down performance slightly, but will not change the results.
}
\examples{
data(bpd_phy); data(bpd_cla); data(bpd_ord); data(bpd_fam); data(bpd_clin)
otu_tabs = list(Phylum = bpd_phy, Class = bpd_cla,
Order = bpd_ord, Family = bpd_fam)

set <- tidy_micro(otu_tabs = otu_tabs, clinical = bpd_clin)

set \%>\% three_mode(table = "Family", group = bpd1, time_var = day, subject = study_id)
}
\author{
Charlie Carpenter, Kayla Williamson
}
