% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta_heatmap.R
\name{beta_heatmap}
\alias{beta_heatmap}
\title{Create heatmaps of the supplied dissimilarity matrices}
\usage{
beta_heatmap(
  beta_div,
  micro_set,
  ...,
  low_grad,
  high_grad,
  main = NULL,
  xlab = NULL,
  ylab = NULL,
  subtitle = NULL,
  natural_order = TRUE,
  legend_title = "Dissimilarity"
)
}
\arguments{
\item{beta_div}{A dissimilarity matrix calculated by \code{beta_div}}

\item{micro_set}{A tidy_micro data set}

\item{...}{Variables for ordering}

\item{low_grad}{Colors for the corelation magnitude. Will be fed into scale_fill_gradient}

\item{high_grad}{Colors for the corelation magnitude. Will be fed into scale_fill_gradient}

\item{main}{Plot title}

\item{xlab}{x-axis label}

\item{ylab}{y-axis label}

\item{subtitle}{Plot label}

\item{natural_order}{Keep order of axes in the conventional order for dissimilarity matrices}

\item{legend_title}{Title for the legend}
}
\value{
Returns a ggplot that you can add geoms to if you'd like
}
\description{
Create heatmaps of the supplied dissimilarity matrices ordered by supplied grouping variables
}
\examples{
data(bpd_phy); data(bpd_cla); data(bpd_ord); data(bpd_fam); data(bpd_clin)

otu_tabs <- list(Phylum = bpd_phy, Class = bpd_cla,
Order = bpd_ord, Family = bpd_fam)
set <- tidy_micro(otu_tabs = otu_tabs, clinical = bpd_clin) \%>\%
filter(day == 7) ## Only including the first week

## Bray-Curtis beta diversity
bray <- set \%>\% beta_div(table = "Family")

bray \%>\% beta_heatmap(micro_set = set, bpd1)
}
