% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxa_summary.R
\name{taxa_summary}
\alias{taxa_summary}
\title{Summarize the information}
\usage{
taxa_summary(micro_set, ..., table = NULL, obj = ra, taxa = TRUE)
}
\arguments{
\item{micro_set}{A tidy_micro data set}

\item{...}{Covariates of interest}

\item{table}{OTU table of interest. If NULL, all tables will be used}

\item{obj}{The taxonomic information of interest}

\item{taxa}{Logical; Whether or not to stratify by taxa}
}
\value{
A tibble containing columns of stratifying variables and several summary columns
}
\description{
Give taxa summary table stratified by variables of interest and/or OTU tables
}
\examples{
data(phy); data(cla); data(ord); data(fam); data(clin)

otu_tabs <- list(Phylum = phy, Class = cla, Order = ord, Family = fam)
set <- tidy_micro(otu_tabs = otu_tabs, clinical = clin) \%>\%
mutate(bpd1 = factor(bpd1))

## Summarize each taxa by Table
set \%>\% taxa_summary

## Summarize each taxa by a categorical variable of interest
set \%>\% taxa_summary(bpd1)

## Summarize each taxa by a categorical variable of interest within a Table
set \%>\% taxa_summary(bpd1, table = "Phylum")

## Summarize within group or table only
set \%>\% taxa_summary(taxa = FALSE)
}
