% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-class-to-parsnip.R
\name{fast_classification_parsnip_spec_tbl}
\alias{fast_classification_parsnip_spec_tbl}
\title{Utility Classification call to \code{parsnip}}
\usage{
fast_classification_parsnip_spec_tbl(
  .parsnip_fns = "all",
  .parsnip_eng = "all"
)
}
\arguments{
\item{.parsnip_fns}{The default for this is set to \code{all}. This means that all
of the parsnip \strong{classification} functions will be used, for example \code{bag_mars()},
or \code{bart()}. You can also choose to pass a c() vector like \code{c("barg_mars","bart")}}

\item{.parsnip_eng}{The default for this is set to \code{all}. This means that all
of the parsnip \strong{classification engines} will be used, for example \code{earth}, or
\code{dbarts}. You can also choose to pass a c() vector like \code{c('earth', 'dbarts')}}
}
\value{
A tibble with an added class of 'fst_class_spec_tbl'
}
\description{
Creates a tibble of parsnip classification model specifications.
}
\details{
Creates a tibble of parsnip classification model specifications. This will
create a tibble of 32 different classification model specifications which can be
filtered. The model specs are created first and then filtered out. This will
only create models for \strong{classification} problems. To find all of the supported
models in this package you can visit \url{https://www.tidymodels.org/find/parsnip/}
}
\examples{
fast_classification_parsnip_spec_tbl(.parsnip_fns = "logistic_reg")
fast_classification_parsnip_spec_tbl(.parsnip_eng = c("earth","dbarts"))

}
\seealso{
Other Utility: 
\code{\link{core_packages}()},
\code{\link{create_splits}()},
\code{\link{create_workflow_set}()},
\code{\link{fast_regression_parsnip_spec_tbl}()},
\code{\link{full_internal_make_wflw}()},
\code{\link{install_deps}()},
\code{\link{load_deps}()},
\code{\link{match_args}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Utility}
