% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partition_index.R
\name{partition_index}
\alias{partition_index}
\title{Partition an index vector into an integer vector representing groups}
\usage{
partition_index(index, period = "yearly", start_date = NULL, ...)
}
\arguments{
\item{index}{A vector of date indices to create groups for.}

\item{period}{A character specification used for time-based grouping. The
general format to use is \code{"frequency period"} where frequency is a number
like 1 or 2, and period is an interval like weekly or yearly. There must be
a space between the two.

Note that you can pass the specification in a flexible way:
\itemize{
\item 1 Year: \code{'1 year'} / \code{'1 Y'} / \code{'1 yearly'} / \code{'yearly'}
}

This shorthand is available for year, quarter, month, day, hour, minute,
second, millisecond and microsecond periodicities.

Additionally, you have the option of passing in a vector of dates to
use as custom and more flexible boundaries.}

\item{start_date}{Optional argument used to
specify the start date for the
first group. The default is to start at the closest period boundary
below the minimum date in the supplied index.}

\item{...}{Not currently used.}
}
\description{
\code{\link[=partition_index]{partition_index()}} takes an index vector and returns an integer vector that
can be used for grouping by periods. This is the workhorse for many other
\code{tibbletime} functions.
}
\details{
This function is used internally, but may provide the user extra flexibility
in some cases.

Grouping can only be done on the minimum periodicity of the index and above.
This means that a daily series cannot be grouped by minute. An hourly series
cannot be grouped by 5 seconds, and so on. If the user attempts this,
an error will be thrown.
}
\examples{

data(FB)

partition_index(FB$date, '2 year')

dplyr::mutate(FB, partition_index = partition_index(date, '2 day'))

}
\seealso{
\code{\link[=as_period]{as_period()}}, \code{\link[=collapse_index]{collapse_index()}}
}
