% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_filter.R
\name{time_filter}
\alias{time_filter}
\alias{[.tbl_time}
\title{Succinctly filter a \code{tbl_time} object by date}
\usage{
time_filter(x, time_formula)

\method{[}{tbl_time}(x, i, j, drop = FALSE)
}
\arguments{
\item{x}{A \code{tbl_time} object.}

\item{time_formula}{A period to filter over.
This is specified as a \code{formula}. See \code{Details}.}

\item{i}{A period to filter over. This is specified the same as
\code{time_formula} or can use the traditional row extraction method.}

\item{j}{Optional argument to also specify column index to subset. Works
exactly like the normal extraction operator.}

\item{drop}{Will always be coerced to \code{FALSE} by \code{tibble}.}
}
\description{
Use a concise filtering method to filter a \code{tbl_time} object by it's \code{index}.
}
\details{
The \code{time_formula} is specified using the format \code{from ~ to}.
Each side of the \code{time_formula} is specified as \code{YYYY-MM-DD + HH:MM:SS},
but powerful shorthand is available. Some examples are:
\itemize{
\item \strong{Year:} \code{2013 ~ 2015}
\item \strong{Month:} \code{2013-01 ~ 2016-06}
\item \strong{Day:} \code{2013-01-05 ~ 2016-06-04}
\item \strong{Second:} \code{2013-01-05 + 10:22:15 ~ 2018-06-03 + 12:14:22}
\item \strong{Variations:} \code{2013 ~ 2016-06}
}

The \code{time_formula} can also use a one sided formula.
\itemize{
\item \strong{Only dates in 2015:} \code{~2015}
\item \strong{Only dates March 2015:} \code{~2015-03}
}

All shorthand dates are expanded to be valid POSIXct dates.
\itemize{
\item The \code{from} side is expanded to be the first date in that period
\item The \code{to} side is expanded to be the last date in that period
}

This means that the following examples are equivalent:
\itemize{
\item \code{2015 ~ 2016 == 2015-01-01 + 00:00:00 ~ 2016-12-31 + 23:59:59}
\item \code{~2015 == 2015-01-01 + 00:00:00 ~ 2015-12-31 + 23:59:59}
\item \code{2015-01-04 + 10:12 ~ 2015-01-05 == 2015-01-04 + 10:12:00 ~ 2015-01-05 + 23:59:59}
}

This function respects \code{\link[dplyr:group_by]{dplyr::group_by()}} groups.
}
\examples{

# FANG contains Facebook, Amazon, Netflix and Google stock prices
data(FANG)
FANG <- as_tbl_time(FANG, date) \%>\%
  dplyr::group_by(symbol)

# 2013-01-01 to 2014-12-31
time_filter(FANG, 2013 ~ 2014)

# 2013-05-25 to 2014-06-04
time_filter(FANG, 2013-05-25 ~ 2014-06-04)

# Using the `[` subset operator
FANG[2014~2015]

# Using `[` and one sided formula for only dates in 2014
FANG[~2014]

# Using `[` and column selection
FANG[2013~2016, c("date", "adjusted")]


}
