% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sounding_export.R
\name{sounding_export}
\alias{sounding_export}
\title{Sounding export}
\usage{
sounding_export(pressure, altitude, temp, dpt, wd, ws)
}
\arguments{
\item{pressure}{pressure [hPa]}

\item{altitude}{altitude [m] (can be above sea level or above ground level as function always consider first level as surface, i.e h = 0 m) altitude [meters]}

\item{temp}{temperature [degree Celsius]}

\item{dpt}{dew point temperature [degree Celsius]}

\item{wd}{wind direction [azimuth in degrees]}

\item{ws}{wind speed [knots]}
}
\value{
Data frame of computed values for visualizing parcel trajectories
 \enumerate{
  \item pressure pressure [hPa]
  \item altitude altitude [m]
  \item temp temperature [degree Celsius]
  \item tempV virtual temperature [degree Celsius]
  \item dpt dew point temperature [degree Celsius]
  \item wd wind direction [azimuth in degrees]
  \item ws wind speed [knots]
  \item MU temperature for most unstable CAPE trajectory [degree Celsius]
  \item SB temperature for surface based CAPE trajectory [degree Celsius]
  \item ML temperature for mixed layer CAPE trajectory [degree Celsius]
}
}
\description{
Internal package function for exporting interpolated profile with 5 m steps
}
\examples{
data("sounding_vienna")
attach(sounding_vienna)
skewt_plot(close_par = FALSE)
output = sounding_export(pressure, altitude, temp, dpt, wd, ws)
skewt_lines(output$dpt, output$pressure, col = 'forestgreen', lwd = 2.5)
skewt_lines(output$temp,output$pressure, col = 'red', lwd = 2.5)
skewt_lines(output$MU,output$pressure, col = "orange", lty = 1, lwd = 2)
skewt_lines(output$tempV,output$pressure, col = "red3", lty = 3, lwd = 1.5)
}
