% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CatalogNode.R
\name{CatalogNode}
\alias{CatalogNode}
\title{A class for Catalogs (which may contain catalogs references or datasets)}
\description{
A catalog representation that sublcasses from ThreddsNode
}
\examples{
 \donttest{
  library(thredds)
  top_uri <- 'https://oceandata.sci.gsfc.nasa.gov/opendap/catalog.xml'
  Top <- thredds::CatalogNode$new(top_uri)
  Top$browse()
  
  #go down in 'MODISA' catalog
  L3 <- Top$get_catalogs("MODISA")[["MODISA"]]$get_catalogs()[[1]]
  
  #see what's available for 2009
  catalog2009 <- L3$get_catalogs("2009")[[1]]
  
  #get catalog for 2009-01-20 
  doy <- format(as.Date("2009-01-20"), "\%j")
  catalog20 <- catalog2009$get_catalogs(doy)[[doy]]
  
  #get dataset node
  chl <- catalog20$get_datasets("A2009020.L3m_DAY_CHL_chlor_a_9km.nc")[[1]]
  
  #retrieve the relative URL, and add it to the base URL for the service.
  #Somewhat awkwardly, the relative URL comes prepended with a path separator, so we 
  #use straight up `paste0` to append to the base_uri.
  if(require("ncdf4")){
    base_uri <- "https://oceandata.sci.gsfc.nasa.gov:443/opendap"
    uri <- paste0(base_uri, chl$url)
    NC <- ncdf4::nc_open(uri)
  }
 }

}
\section{Super class}{
\code{\link[thredds:ThreddsNode]{thredds::ThreddsNode}} -> \code{CatalogNode}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-list_services}{\code{CatalogNode$list_services()}}
\item \href{#method-list_catalogs}{\code{CatalogNode$list_catalogs()}}
\item \href{#method-list_datasets}{\code{CatalogNode$list_datasets()}}
\item \href{#method-get_catalogs}{\code{CatalogNode$get_catalogs()}}
\item \href{#method-get_datasets}{\code{CatalogNode$get_datasets()}}
\item \href{#method-get_dataset_names}{\code{CatalogNode$get_dataset_names()}}
\item \href{#method-get_catalog_names}{\code{CatalogNode$get_catalog_names()}}
\item \href{#method-parse_catalog_node}{\code{CatalogNode$parse_catalog_node()}}
\item \href{#method-parse_dataset_node}{\code{CatalogNode$parse_dataset_node()}}
\item \href{#method-print}{\code{CatalogNode$print()}}
\item \href{#method-clone}{\code{CatalogNode$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="thredds" data-topic="ThreddsNode" data-id="browse">}\href{../../thredds/html/ThreddsNode.html#method-browse}{\code{thredds::ThreddsNode$browse()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="thredds" data-topic="ThreddsNode" data-id="children_names">}\href{../../thredds/html/ThreddsNode.html#method-children_names}{\code{thredds::ThreddsNode$children_names()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="thredds" data-topic="ThreddsNode" data-id="GET">}\href{../../thredds/html/ThreddsNode.html#method-GET}{\code{thredds::ThreddsNode$GET()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="thredds" data-topic="ThreddsNode" data-id="initialize">}\href{../../thredds/html/ThreddsNode.html#method-initialize}{\code{thredds::ThreddsNode$initialize()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-list_services"></a>}}
\if{latex}{\out{\hypertarget{method-list_services}{}}}
\subsection{Method \code{list_services()}}{
list available services
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CatalogNode$list_services(
  xpath = build_xpath("service", prefix = self$prefix),
  form = "list"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xpath}}{character, the xpath specifications}

\item{\code{form}}{character, either "list" or "table"}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
list of zero or more character vectors
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-list_catalogs"></a>}}
\if{latex}{\out{\hypertarget{method-list_catalogs}{}}}
\subsection{Method \code{list_catalogs()}}{
list available catalogRefs
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CatalogNode$list_catalogs(
  xpath = build_xpath(c("dataset", "catalogRef"), prefix = self$prefix),
  form = "list"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xpath}}{character, the xpath descriptor}

\item{\code{form}}{character, either "list" or "table"}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a list with zero or more character vectors
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-list_datasets"></a>}}
\if{latex}{\out{\hypertarget{method-list_datasets}{}}}
\subsection{Method \code{list_datasets()}}{
list available datasets
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CatalogNode$list_datasets(
  xpath = build_xpath(c("dataset", "dataset"), prefix = self$prefix),
  form = "list"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xpath}}{character, the xpath descriptor}

\item{\code{form}}{character, either "list" or "table"}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a list with zero or more character vectors
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_catalogs"></a>}}
\if{latex}{\out{\hypertarget{method-get_catalogs}{}}}
\subsection{Method \code{get_catalogs()}}{
Retrieve a list one or more of child catalogs
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CatalogNode$get_catalogs(
  index,
  xpath = build_xpath(c("dataset", "catalogRef"), prefix = self$prefix)
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{index}}{integer index (1,...,nChild), indices or name(s)}

\item{\code{xpath}}{character xpath representation}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a list of Catalog class objects, possibly NULL
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_datasets"></a>}}
\if{latex}{\out{\hypertarget{method-get_datasets}{}}}
\subsection{Method \code{get_datasets()}}{
Retrieve list one or more dataset children
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CatalogNode$get_datasets(
  index,
  xpath = build_xpath(c("dataset", "dataset"), prefix = self$prefix)
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{index}}{the integer index (1,...,nChild), indices or name(s)}

\item{\code{xpath}}{character xpath representation}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a list of Dataset objects or NULL
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_dataset_names"></a>}}
\if{latex}{\out{\hypertarget{method-get_dataset_names}{}}}
\subsection{Method \code{get_dataset_names()}}{
Retrieve list zero or more dataset child names.  If unnnamed, then
  we substitute "title", "ID", "urlPath", or "href" in that order of availability.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CatalogNode$get_dataset_names(
  xpath = build_xpath(c("dataset", "dataset"), prefix = self$prefix)
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xpath}}{character xpath representation}

\item{\code{index}}{the integer index (1,...,nChild), indices or name(s)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
character vector of zero or more names
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_catalog_names"></a>}}
\if{latex}{\out{\hypertarget{method-get_catalog_names}{}}}
\subsection{Method \code{get_catalog_names()}}{
Retrieve list zero or more catalog child names.  If unnnamed, then
  we substitute "title", "ID", "urlPath" or href" in that order of availability.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CatalogNode$get_catalog_names(
  xpath = build_xpath(c("dataset", "catalogRef"), prefix = self$prefix)
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xpath}}{character xpath representation}

\item{\code{index}}{the integer index (1,...,nChild), indices or name(s)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
character vector of zero or more names
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-parse_catalog_node"></a>}}
\if{latex}{\out{\hypertarget{method-parse_catalog_node}{}}}
\subsection{Method \code{parse_catalog_node()}}{
Parse a catalog node
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CatalogNode$parse_catalog_node(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{xml_node}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Catalog class object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-parse_dataset_node"></a>}}
\if{latex}{\out{\hypertarget{method-parse_dataset_node}{}}}
\subsection{Method \code{parse_dataset_node()}}{
Parse a dataset node
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CatalogNode$parse_dataset_node(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{xml_node}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Dataset class object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
print method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CatalogNode$print(prefix = "")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{prefix}}{character, to be printed before each line of output (like spaces)}

\item{\code{...}}{other arguments for superclass}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CatalogNode$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
