% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/witcher_spells.R
\name{witcherMap}
\alias{witcherMap}
\alias{witcher}
\alias{witcher_pal}
\alias{witcher_palette_names}
\alias{witcher_colors}
\title{The Witcher Colour Map.}
\usage{
witcherMap(
  n = 256,
  alpha = 1,
  begin = 0,
  end = 1,
  direction = 1,
  option = "Geralt"
)

witcher(n, alpha = 1, begin = 0, end = 1, direction = 1, option = "Geralt")

witcher_pal(alpha = 1, begin = 0, end = 1, direction = 1, option = "Geralt")

witcher(n, alpha = 1, begin = 0, end = 1, direction = 1, option = "Geralt")

witcher_palette_names()

witcher_colors()
}
\arguments{
\item{n}{The number of colors (\eqn{\ge 1}) to be in the palette.}

\item{alpha}{The alpha transparency, a number in from 0 to 1, see argument alpha in
\code{\link[grDevices]{hsv}}.}

\item{begin}{The (corrected) hue in from 0 to 1 at which the witcher colormap begins.}

\item{end}{The (corrected) hue in from 0 to 1 at which the witcher colormap ends.}

\item{direction}{Sets the order of colors in the scale. If 1, the default, colors
are ordered from darkest to lightest. If -1, the order of colors is reversed.}

\item{option}{A character string indicating the colourmap to use. It is not case-sensible}

\item{palettes}{one or more palettes to show}
}
\value{
\code{witcher} returns a character vector, \code{cv}, of color hex
codes. This can be used either to create a user-defined color palette for
subsequent graphics by \code{palette(cv)}, a \code{col =} specification in
graphics functions or in \code{par}.

\code{witcherMap} returns a \code{n} lines data frame containing the
red (\code{R}), green (\code{G}), blue (\code{B}) and alpha (\code{alpha})
channels of \code{n} equally spaced colors along the 'The Witcher' colour map.
\code{n = 256} by default.
}
\description{
This function creates a vector of \code{n} equally spaced colors along the
'witcher colour map'.

A simple function that returns a plot of all available palettes in the \code{theWitcher} - package
}
\examples{



pal <- witcher(255, option = "Geralt")
image(volcano, col = pal)

library(ggplot2)

ggplot(data.frame(x = rnorm(10000), y = rnorm(10000)), aes(x = x, y = y)) +
geom_hex() + coord_fixed() +
scale_fill_witcher(option="school_griffin") + theme_bw()

}
\author{
Lukas Graf \email{graflukas57@gmail.com}

Semi-transparent colors (\eqn{0 < alpha < 1}) are supported only on some
devices: see \code{\link[grDevices]{rgb}}.
}
\keyword{internal}
