% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distribution-methods.R
\name{tfd_quantile}
\alias{tfd_quantile}
\title{Quantile function. Aka "inverse cdf" or "percent point function".}
\usage{
tfd_quantile(distribution, value, ...)
}
\arguments{
\item{distribution}{The distribution being used.}

\item{value}{float or double Tensor.}

\item{...}{Additional parameters passed to Python.}
}
\value{
a Tensor of shape \code{sample_shape(x) + self$batch_shape} with values of type \code{self$dtype}.
}
\description{
Given random variable X and p in \code{[0, 1]}, the quantile is:
\code{tfd_quantile(p) := x} such that \code{P[X <= x] == p}
}
\examples{
\donttest{
  d <- tfd_normal(loc = c(1, 2), scale = c(1, 0.5))
  d \%>\% tfd_quantile(0.5)
}
}
\seealso{
Other distribution_methods: \code{\link{tfd_cdf}},
  \code{\link{tfd_covariance}},
  \code{\link{tfd_cross_entropy}},
  \code{\link{tfd_entropy}},
  \code{\link{tfd_kl_divergence}},
  \code{\link{tfd_log_cdf}}, \code{\link{tfd_log_prob}},
  \code{\link{tfd_log_survival_function}},
  \code{\link{tfd_mean}}, \code{\link{tfd_mode}},
  \code{\link{tfd_prob}}, \code{\link{tfd_sample}},
  \code{\link{tfd_stddev}},
  \code{\link{tfd_survival_function}},
  \code{\link{tfd_variance}}
}
\concept{distribution_methods}
