% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{tfd_inverse_gaussian}
\alias{tfd_inverse_gaussian}
\title{Inverse Gaussian distribution}
\usage{
tfd_inverse_gaussian(loc, concentration, validate_args = FALSE,
  allow_nan_stats = TRUE, name = "InverseGaussian")
}
\arguments{
\item{loc}{Floating-point \code{Tensor}, the loc params. Must contain only positive values.}

\item{concentration}{Floating-point \code{Tensor}, the concentration params. Must contain only positive values.}

\item{validate_args}{Logical, default FALSE. When TRUE distribution parameters are checked
for validity despite possibly degrading runtime performance. When FALSE invalid inputs may
silently render incorrect outputs. Default value: FALSE.}

\item{allow_nan_stats}{Logical, default TRUE. When TRUE, statistics (e.g., mean, mode, variance)
use the value NaN to indicate the result is undefined. When FALSE, an exception is raised if
one or more of the statistic's batch members are undefined.}

\item{name}{name prefixed to Ops created by this class.}
}
\value{
a distribution instance.
}
\description{
The \href{https://en.wikipedia.org/wiki/Inverse_Gaussian_distribution}{inverse Gaussian distribution}
is parameterized by a \code{loc} and a \code{concentration} parameter. It's also known
as the Wald distribution. Some, e.g., the Python scipy package, refer to the
special case when \code{loc} is 1 as the Wald distribution.
}
\details{
The "inverse" in the name does not refer to the distribution associated to
the multiplicative inverse of a random variable. Rather, the cumulant
generating function of this distribution is the inverse to that of a Gaussian
random variable.

Mathematical Details

The probability density function (pdf) is,\preformatted{pdf(x; mu, lambda) = [lambda / (2 pi x ** 3)] ** 0.5
exp{-lambda(x - mu) ** 2 / (2 mu ** 2 x)}
}

where
\itemize{
\item \code{loc = mu}
\item \code{concentration = lambda}.
}

The support of the distribution is defined on \code{(0, infinity)}.
Mapping to R and Python scipy's parameterization:
\itemize{
\item R: statmod::invgauss
}
\itemize{
\item mean = loc
\item shape = concentration
\item dispersion = 1 / concentration. Used only if shape is NULL.
}
\itemize{
\item Python: scipy.stats.invgauss
}
\itemize{
\item mu = loc / concentration
\item scale = concentration
}
}
\seealso{
For usage examples see e.g. \code{\link[=tfd_sample]{tfd_sample()}}, \code{\link[=tfd_log_prob]{tfd_log_prob()}}, \code{\link[=tfd_mean]{tfd_mean()}}.

Other distributions: \code{\link{tfd_autoregressive}},
  \code{\link{tfd_batch_reshape}},
  \code{\link{tfd_bernoulli}}, \code{\link{tfd_beta}},
  \code{\link{tfd_binomial}},
  \code{\link{tfd_categorical}}, \code{\link{tfd_cauchy}},
  \code{\link{tfd_chi2}}, \code{\link{tfd_chi}},
  \code{\link{tfd_cholesky_lkj}},
  \code{\link{tfd_deterministic}},
  \code{\link{tfd_dirichlet_multinomial}},
  \code{\link{tfd_dirichlet}}, \code{\link{tfd_empirical}},
  \code{\link{tfd_exponential}},
  \code{\link{tfd_gamma_gamma}}, \code{\link{tfd_gamma}},
  \code{\link{tfd_gaussian_process_regression_model}},
  \code{\link{tfd_gaussian_process}},
  \code{\link{tfd_geometric}}, \code{\link{tfd_gumbel}},
  \code{\link{tfd_half_cauchy}},
  \code{\link{tfd_half_normal}},
  \code{\link{tfd_hidden_markov_model}},
  \code{\link{tfd_horseshoe}},
  \code{\link{tfd_independent}},
  \code{\link{tfd_inverse_gamma}},
  \code{\link{tfd_joint_distribution_named}},
  \code{\link{tfd_joint_distribution_sequential}},
  \code{\link{tfd_kumaraswamy}}, \code{\link{tfd_laplace}},
  \code{\link{tfd_linear_gaussian_state_space_model}},
  \code{\link{tfd_lkj}}, \code{\link{tfd_log_normal}},
  \code{\link{tfd_logistic}},
  \code{\link{tfd_mixture_same_family}},
  \code{\link{tfd_mixture}}, \code{\link{tfd_multinomial}},
  \code{\link{tfd_multivariate_normal_diag_plus_low_rank}},
  \code{\link{tfd_multivariate_normal_diag}},
  \code{\link{tfd_multivariate_normal_full_covariance}},
  \code{\link{tfd_multivariate_normal_linear_operator}},
  \code{\link{tfd_multivariate_normal_tri_l}},
  \code{\link{tfd_multivariate_student_t_linear_operator}},
  \code{\link{tfd_negative_binomial}},
  \code{\link{tfd_normal}},
  \code{\link{tfd_one_hot_categorical}},
  \code{\link{tfd_pareto}}, \code{\link{tfd_pixel_cnn}},
  \code{\link{tfd_poisson_log_normal_quadrature_compound}},
  \code{\link{tfd_poisson}},
  \code{\link{tfd_probit_bernoulli}},
  \code{\link{tfd_quantized}},
  \code{\link{tfd_relaxed_bernoulli}},
  \code{\link{tfd_relaxed_one_hot_categorical}},
  \code{\link{tfd_sample_distribution}},
  \code{\link{tfd_sinh_arcsinh}},
  \code{\link{tfd_student_t_process}},
  \code{\link{tfd_student_t}},
  \code{\link{tfd_transformed_distribution}},
  \code{\link{tfd_triangular}},
  \code{\link{tfd_truncated_normal}},
  \code{\link{tfd_uniform}},
  \code{\link{tfd_variational_gaussian_process}},
  \code{\link{tfd_vector_diffeomixture}},
  \code{\link{tfd_vector_exponential_diag}},
  \code{\link{tfd_vector_exponential_linear_operator}},
  \code{\link{tfd_vector_laplace_diag}},
  \code{\link{tfd_vector_laplace_linear_operator}},
  \code{\link{tfd_vector_sinh_arcsinh_diag}},
  \code{\link{tfd_von_mises_fisher}},
  \code{\link{tfd_von_mises}},
  \code{\link{tfd_wishart_linear_operator}},
  \code{\link{tfd_wishart_tri_l}},
  \code{\link{tfd_wishart}}, \code{\link{tfd_zipf}}
}
\concept{distributions}
