% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sts.R
\name{sts_seasonal}
\alias{sts_seasonal}
\title{Formal representation of a seasonal effect model.}
\usage{
sts_seasonal(observed_time_series = NULL, num_seasons,
  num_steps_per_season = 1, drift_scale_prior = NULL,
  initial_effect_prior = NULL, constrain_mean_effect_to_zero = TRUE,
  name = NULL)
}
\arguments{
\item{observed_time_series}{optional \code{float} \code{tensor} of shape
\code{batch_shape + [T, 1]} (omitting the trailing unit dimension is also
supported when \code{T > 1}), specifying an observed time series.
Any priors not explicitly set will be given default values according to
the scale of the observed time series (or batch of time series). May
optionally be an instance of \code{sts_masked_time_series}, which includes
a mask \code{tensor} to specify timesteps with missing observations.
Default value: \code{NULL}.}

\item{num_seasons}{Scalar \code{integer} number of seasons.}

\item{num_steps_per_season}{\code{integer} number of steps in each
season. This may be either a scalar (shape \code{[]}), in which case all
seasons have the same length, or an array of shape \code{[num_seasons]},
in which seasons have different length, but remain constant around
different cycles, or an array of shape \code{[num_cycles, num_seasons]},
in which num_steps_per_season for each season also varies in different
cycle (e.g., a 4 years cycle with leap day). Default value: 1.}

\item{drift_scale_prior}{optional \code{tfd$Distribution} instance specifying a prior
on the \code{drift_scale} parameter. If \code{NULL}, a heuristic default prior is
constructed based on the provided \code{observed_time_series}. Default value: \code{NULL}.}

\item{initial_effect_prior}{optional \code{tfd$Distribution} instance specifying a
normal prior on the initial effect of each season. This may be either
a scalar \code{tfd_normal} prior, in which case it applies independently to
every season, or it may be multivariate normal (e.g.,
\code{tfd_multivariate_normal_diag}) with event shape \code{[num_seasons]}, in
which case it specifies a joint prior across all seasons. If \code{NULL}, a
heuristic default prior is constructed based on the provided
\code{observed_time_series}. Default value: \code{NULL}.}

\item{constrain_mean_effect_to_zero}{if \code{TRUE}, use a model parameterization
that constrains the mean effect across all seasons to be zero. This
constraint is generally helpful in identifying the contributions of
different model components and can lead to more interpretable
posterior decompositions. It may be undesirable if you plan to directly
examine the latent space of the underlying state space model. Default value: \code{TRUE}.}

\item{name}{the name of this model component. Default value: 'Seasonal'.}
}
\value{
an instance of \code{StructuralTimeSeries}.
}
\description{
A seasonal effect model posits a fixed set of recurring, discrete 'seasons',
each of which is active for a fixed number of timesteps and, while active,
contributes a different effect to the time series. These are generally not
meteorological seasons, but represent regular recurring patterns such as
hour-of-day or day-of-week effects. Each season lasts for a fixed number of
timesteps. The effect of each season drifts from one occurrence to the next
following a Gaussian random walk:
}
\details{
\preformatted{effects[season, occurrence[i]] = (
  effects[season, occurrence[i-1]] + Normal(loc=0., scale=drift_scale))
}

The \code{drift_scale} parameter governs the standard deviation of the random walk;
for example, in a day-of-week model it governs the change in effect from this
Monday to next Monday.
}
\seealso{
For usage examples see \code{\link[=sts_fit_with_hmc]{sts_fit_with_hmc()}}, \code{\link[=sts_forecast]{sts_forecast()}}, \code{\link[=sts_decompose_by_component]{sts_decompose_by_component()}}.

Other sts: \code{\link{sts_additive_state_space_model}},
  \code{\link{sts_autoregressive_state_space_model}},
  \code{\link{sts_autoregressive}},
  \code{\link{sts_constrained_seasonal_state_space_model}},
  \code{\link{sts_dynamic_linear_regression_state_space_model}},
  \code{\link{sts_dynamic_linear_regression}},
  \code{\link{sts_linear_regression}},
  \code{\link{sts_local_level_state_space_model}},
  \code{\link{sts_local_level}},
  \code{\link{sts_local_linear_trend_state_space_model}},
  \code{\link{sts_local_linear_trend}},
  \code{\link{sts_seasonal_state_space_model}},
  \code{\link{sts_semi_local_linear_trend_state_space_model}},
  \code{\link{sts_semi_local_linear_trend}},
  \code{\link{sts_smooth_seasonal_state_space_model}},
  \code{\link{sts_smooth_seasonal}},
  \code{\link{sts_sparse_linear_regression}},
  \code{\link{sts_sum}}
}
\concept{sts}
