% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sts.R
\name{sts_local_level}
\alias{sts_local_level}
\title{Formal representation of a local level model}
\usage{
sts_local_level(
  observed_time_series = NULL,
  level_scale_prior = NULL,
  initial_level_prior = NULL,
  name = NULL
)
}
\arguments{
\item{observed_time_series}{optional \code{float} \code{tensor} of shape
\verb{batch_shape + [T, 1]} (omitting the trailing unit dimension is also
supported when \code{T > 1}), specifying an observed time series.
Any priors not explicitly set will be given default values according to
the scale of the observed time series (or batch of time series). May
optionally be an instance of \code{sts_masked_time_series}, which includes
a mask \code{tensor} to specify timesteps with missing observations.
Default value: \code{NULL}.}

\item{level_scale_prior}{optional \code{tfp$distribution} instance specifying a prior
on the \code{level_scale} parameter. If \code{NULL}, a heuristic default prior is
constructed based on the provided \code{observed_time_series}.
Default value: \code{NULL}.}

\item{initial_level_prior}{optional \code{tfp$distribution} instance specifying a
prior on the initial level. If \code{NULL}, a heuristic default prior is
constructed based on the provided \code{observed_time_series}.
Default value: \code{NULL}.}

\item{name}{the name of this model component. Default value: 'LocalLevel'.}
}
\value{
an instance of \code{StructuralTimeSeries}.
}
\description{
The local level model posits a \code{level} evolving via a Gaussian random walk:\preformatted{level[t] = level[t-1] + Normal(0., level_scale)
}
}
\details{
The latent state is \verb{[level]}. We observe a noisy realization of the current
level: \code{f[t] = level[t] + Normal(0., observation_noise_scale)} at each timestep.
}
\seealso{
For usage examples see \code{\link[=sts_fit_with_hmc]{sts_fit_with_hmc()}}, \code{\link[=sts_forecast]{sts_forecast()}}, \code{\link[=sts_decompose_by_component]{sts_decompose_by_component()}}.

Other sts: 
\code{\link{sts_additive_state_space_model}()},
\code{\link{sts_autoregressive_state_space_model}()},
\code{\link{sts_autoregressive}()},
\code{\link{sts_constrained_seasonal_state_space_model}()},
\code{\link{sts_dynamic_linear_regression_state_space_model}()},
\code{\link{sts_dynamic_linear_regression}()},
\code{\link{sts_linear_regression}()},
\code{\link{sts_local_level_state_space_model}()},
\code{\link{sts_local_linear_trend_state_space_model}()},
\code{\link{sts_local_linear_trend}()},
\code{\link{sts_seasonal_state_space_model}()},
\code{\link{sts_seasonal}()},
\code{\link{sts_semi_local_linear_trend_state_space_model}()},
\code{\link{sts_semi_local_linear_trend}()},
\code{\link{sts_smooth_seasonal_state_space_model}()},
\code{\link{sts_smooth_seasonal}()},
\code{\link{sts_sparse_linear_regression}()},
\code{\link{sts_sum}()}
}
\concept{sts}
