% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stsm.R
\name{bsm}
\alias{bsm}
\title{Basic Structural Time Series models}
\usage{
bsm(
  y,
  bc = FALSE,
  seas = c("hd", "ht", "hs"),
  s2v = c(lvl = 0.2, slp = 0.05, seas = 0.075),
  s2u = 0.1,
  xreg = NULL,
  fSv = NULL,
  ...
)
}
\arguments{
\item{y}{an object of class \code{ts}, with frequency 4 or 12.}

\item{bc}{logical. If TRUE logs are taken.}

\item{seas}{character, type of seasonality (Harvey-Durbin (hd), Harvey-Todd
(ht), Harrison-Steven (ht))}

\item{s2v}{variances of the error vector v_t.}

\item{s2u}{variance of the error u_t.}

\item{xreg}{matrix of regressors.}

\item{fSv}{function to create the covariance matrix of v_t.}

\item{...}{other arguments.}
}
\value{
An object of class \code{stsm}.
}
\description{
\code{bsm} creates/estimates basic structural models for seasonal time
series.
}
\examples{

bsm1 <- bsm(AirPassengers, bc = TRUE)

}
\references{
Durbin, J. and Koopman, S.J. (2012) Time Series Analysis by State Space
Methods, 2nd ed., Oxford University Press, Oxford.
}
