% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HellDist.R
\name{HellDist}
\alias{HellDist}
\title{Hellinger Distance}
\usage{
HellDist(x, y = NULL, by_rows = TRUE)
}
\arguments{
\item{x}{A numeric matrix or numeric vector}

\item{y}{A numeric vector. \code{y} must be specified if \code{x} is a numeric vector.}

\item{by_rows}{Logical. If \code{x} is a matrix, should distances be calculated by rows?}
}
\value{
If \code{x} is a matrix, this returns an square and symmetric matrix. 
The i,j entries correspond to the Hellinger Distance between the rows of \code{x} 
(or the columns of \code{x} if \code{by_rows = FALSE}). If \code{x} and \code{y}
are vectors, this returns a numeric scalar whose value is the Hellinger Distance
between \code{x} and \code{y}.
}
\description{
Calculates the Hellinger distances or the rows or columns of a 
numeric matrix or for two numeric vectors. This function is deprecated. Use
\code{\link[textmineR]{CalcHellingerDist}} instead.
}
\examples{
x <- rchisq(n = 100, df = 8)
y <- x^2
HellDist(x = x, y = y)

mymat <- rbind(x, y)
HellDist(x = mymat)
}
\keyword{distance}
\keyword{functions}

