% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MakeSparseDTM.R
\name{MakeSparseDTM}
\alias{MakeSparseDTM}
\title{Convert a sparse simple triplet document term matrix to a sparse Matrix}
\usage{
MakeSparseDTM(dtm)
}
\arguments{
\item{dtm}{A \code{DocumentTermMatrix} object from the \code{tm} package}
}
\value{
Returns an object of class \code{dgCMatrix}, a sparse matrix, whose columns
correspond to terms and rows correspond to documents.
}
\description{
This function takes a \code{DocumentTermMatrix} from the 
\code{tm} package, and converts it to a \code{CSparse} matrix from the 
\code{Matrix} package. Generally, it is designed to be an internal function
to \code{textmineR}. However, it is available in case users want to use the 
\code{tm} package directly to make a DTM.
}
\examples{
\dontrun{
my_dtm <- tm::DocumentTermMatrix(my_corpus_object)

MakeSparseDtm(dtm = my_dtm)
}
}

