% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replace_ordinal.R
\name{replace_ordinal}
\alias{replace_ordinal}
\title{Replace Mixed Ordinal Numbers With Text Representation}
\usage{
replace_ordinal(x, num.paste = FALSE, remove = FALSE, ...)
}
\arguments{
\item{x}{The text variable.}

\item{num.paste}{logical.  If \code{TRUE} a the elements of larger numbers are 
separated with spaces.  If \code{FALSE} the elements will be joined without 
spaces.}

\item{remove}{logical.  If \code{TRUE} ordinal numbers are removed from the text.}

\item{\ldots}{ignored.}
}
\description{
Replaces mixed text/numeric represented ordinal numbers with words (e.g., 
"1st" becomes "first").
}
\note{
Currently only implemented for ordinal values 1 through 100
}
\examples{
x <- c(
    "I like the 1st one not the 22nd one.", 
    "For the 100th time stop!"
)
replace_ordinal(x)
replace_ordinal(x, TRUE)
replace_ordinal(x, remove = TRUE)
replace_number(replace_ordinal("I like the 1st 1 not the 22nd 1."))
}
\keyword{ordinal-to-word}
