% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crosstab.R
\name{crosstab_sdg}
\alias{crosstab_sdg}
\title{Compare query systems and SDGs}
\usage{
crosstab_sdg(hits, compare = c("systems", "sdgs"), systems = NULL, sdgs = NULL)
}
\arguments{
\item{hits}{\code{data frame} as returned by \code{\link{detect_sdg_systems}}. Must include columns \code{document}, \code{sdg}, \code{system}, and \code{hit}.}

\item{compare}{\code{character} specifying whether systems or SDGs should be cross tabulated.}

\item{systems}{\code{character} vector specifying the query systems to be cross tabulated. Values must be available in the \code{system} column of \code{hits}. Defaults to \code{NULL} in which case available values are retrieved from \code{hits}.}

\item{sdgs}{\code{numeric} vector with integers between 1 and 17 specifying the SDGs to be cross tabluated. Values must be available in the \code{sdg} column of \code{hits}. Defaults to \code{NULL} in which case available values are retrieved from \code{hits}.}
}
\value{
\code{matrix} showing correlation coefficients for all pairs of query systems (if \code{compare = "systems"}) or SDGs (if \code{compare = "SDGs"}).
}
\description{
\code{crosstab_sdg} calculates cross tables (aka contingency tables) of SGSs or systems across hits identified via \link{detect_sdg_systems}.
}
\details{
\code{crosstab_sdg} determines correlations between either query systems or SDGs. The respectively other dimension will be ignored. Note that correlations between SDGs may vary between query systems.
}
\examples{
\donttest{
# run sdg detection
hits <- detect_sdg_systems(projects)

# create cross table of systems
crosstab_sdg(hits)

# create cross table of systems
crosstab_sdg(hits, compare = "sdgs")
}
}
